/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.db.simple.types;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.jacorb.trading.db.simple.types.Incarnation;
import org.jacorb.trading.db.simple.types.TypeProperty;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.IncarnationNumber;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.PropStruct;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.TypeStruct;

public class Type
implements Serializable {
    private String m_name;
    private String m_interfaceName;
    private Vector m_properties;
    private String[] m_superTypes;
    private Incarnation m_incarnation;
    private boolean m_masked;
    private transient TypeStruct m_description;
    static final long serialVersionUID = -4144073280876434847L;

    public Type() {
    }

    public Type(String name, String interfaceName, PropStruct[] props, String[] superTypes, IncarnationNumber inc) {
        int i;
        this.m_name = name;
        this.m_interfaceName = interfaceName;
        this.m_incarnation = new Incarnation(inc);
        this.m_masked = false;
        this.m_superTypes = new String[superTypes.length];
        for (i = 0; i < superTypes.length; ++i) {
            this.m_superTypes[i] = superTypes[i];
        }
        this.m_properties = new Vector();
        for (i = 0; i < props.length; ++i) {
            TypeProperty prop = new TypeProperty(props[i]);
            this.m_properties.addElement(prop);
        }
        this.createDescription();
    }

    public TypeStruct describe() {
        return this.m_description;
    }

    public PropStruct getPropertyInfo(String name) {
        PropStruct result = null;
        for (int i = 0; i < this.m_description.props.length && result == null; ++i) {
            if (!name.equals(this.m_description.props[i].name)) continue;
            result = this.m_description.props[i];
        }
        return result;
    }

    public String getName() {
        return this.m_name;
    }

    public String getInterfaceName() {
        return this.m_interfaceName;
    }

    public boolean getMasked() {
        return this.m_masked;
    }

    public String[] getSuperTypes() {
        return this.m_description.super_types;
    }

    public void mask() {
        this.m_masked = true;
        this.m_description.masked = true;
    }

    public void unmask() {
        this.m_masked = false;
        this.m_description.masked = false;
    }

    public Incarnation getIncarnation() {
        return this.m_incarnation;
    }

    public int hashCode() {
        return this.m_name.hashCode();
    }

    public boolean equals(Object o) {
        Type impl = (Type)o;
        return this.m_name.equals(impl.getName());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.createDescription();
    }

    private void createDescription() {
        this.m_description = new TypeStruct();
        this.m_description.if_name = this.m_interfaceName;
        this.m_description.masked = this.m_masked;
        this.m_description.incarnation = this.m_incarnation.getIncarnationNumber();
        this.m_description.props = new PropStruct[this.m_properties.size()];
        int count = 0;
        Enumeration e = this.m_properties.elements();
        while (e.hasMoreElements()) {
            TypeProperty prop = (TypeProperty)e.nextElement();
            this.m_description.props[count] = prop.describe();
            ++count;
        }
        this.m_description.super_types = new String[this.m_superTypes.length];
        for (int i = 0; i < this.m_superTypes.length; ++i) {
            this.m_description.super_types[i] = this.m_superTypes[i];
        }
    }
}

