/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.db.simple.offers;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.jacorb.trading.TradingService;
import org.jacorb.trading.db.simple.offers.OfferProperty;
import org.jacorb.trading.db.simple.offers.ProxyPolicy;
import org.omg.CORBA.Object;
import org.omg.CosTrading.Lookup;
import org.omg.CosTrading.LookupHelper;
import org.omg.CosTrading.Policy;
import org.omg.CosTrading.Property;
import org.omg.CosTrading.ProxyPackage.ProxyInfo;

public class ProxyOffer
implements Serializable {
    private String m_id;
    private String m_target;
    private Vector m_props;
    private boolean m_ifMatchAll;
    private String m_recipe;
    private Vector m_policies;
    private transient ProxyInfo m_description;
    static final long serialVersionUID = -2760477527985159980L;

    private ProxyOffer() {
    }

    public ProxyOffer(String id, Lookup target, Property[] props, boolean ifMatchAll, String recipe, Policy[] policies) {
        this.m_id = id;
        this.m_target = TradingService.getORB().object_to_string(target);
        this.setProperties(props);
        this.m_ifMatchAll = ifMatchAll;
        this.m_recipe = recipe;
        this.setPolicies(policies);
        this.m_description = null;
    }

    public ProxyInfo describe() {
        ProxyInfo result = null;
        if (this.m_description == null) {
            result = new ProxyInfo();
            Object obj = TradingService.getORB().string_to_object(this.m_target);
            result.target = LookupHelper.narrow(obj);
            result.properties = new Property[this.m_props.size()];
            int count = 0;
            Enumeration e = this.m_props.elements();
            while (e.hasMoreElements()) {
                OfferProperty prop = (OfferProperty)e.nextElement();
                result.properties[count] = prop.describe();
                ++count;
            }
            result.if_match_all = this.m_ifMatchAll;
            result.recipe = this.m_recipe;
            result.policies_to_pass_on = new Policy[this.m_policies.size()];
            count = 0;
            e = this.m_policies.elements();
            while (e.hasMoreElements()) {
                ProxyPolicy policy = (ProxyPolicy)e.nextElement();
                result.policies_to_pass_on[count] = policy.describe();
                ++count;
            }
            this.m_description = result;
        } else {
            result = this.m_description;
        }
        return result;
    }

    public int hashCode() {
        return this.m_id.hashCode();
    }

    public boolean equals(java.lang.Object o) {
        ProxyOffer proxy = (ProxyOffer)o;
        return this.m_id.equals(proxy.m_id);
    }

    protected void setProperties(Property[] props) {
        this.m_props = new Vector();
        for (int i = 0; i < props.length; ++i) {
            OfferProperty prop = new OfferProperty(props[i]);
            this.m_props.addElement(prop);
        }
    }

    protected void setPolicies(Policy[] policies) {
        this.m_policies = new Vector();
        for (int i = 0; i < policies.length; ++i) {
            ProxyPolicy policy = new ProxyPolicy(policies[i]);
            this.m_policies.addElement(policy);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.m_description = null;
    }
}

