/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.constraint;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Hashtable;

public class Lex {
    private StringBuffer m_input;
    private int m_token = 0;
    private StringBuffer m_buffer = new StringBuffer();
    private String m_lexeme = null;
    private int m_pos = 0;
    private Hashtable m_literals = new Hashtable();
    private boolean m_eof = false;
    public static final int ERROR = 0;
    public static final int END = 1;
    public static final int LPAREN = 2;
    public static final int RPAREN = 3;
    public static final int EXIST = 4;
    public static final int MINUS = 5;
    public static final int NOT = 6;
    public static final int MULT = 7;
    public static final int DIV = 8;
    public static final int PLUS = 9;
    public static final int TILDE = 10;
    public static final int IN = 11;
    public static final int EQUAL = 12;
    public static final int NOT_EQUAL = 13;
    public static final int LESS = 14;
    public static final int LESS_EQUAL = 15;
    public static final int GREATER = 16;
    public static final int GREATER_EQUAL = 17;
    public static final int AND = 18;
    public static final int OR = 19;
    public static final int IDENT = 20;
    public static final int TRUE_LIT = 21;
    public static final int FALSE_LIT = 22;
    public static final int STRING_LIT = 23;
    public static final int NUMBER_LIT = 24;
    public static final int PREF_MIN = 25;
    public static final int PREF_MAX = 26;
    public static final int PREF_WITH = 27;
    public static final int PREF_RANDOM = 28;
    public static final int PREF_FIRST = 29;

    private Lex() {
    }

    public Lex(Reader reader) {
        BufferedReader br = new BufferedReader(reader);
        this.m_input = new StringBuffer();
        boolean eof = false;
        char[] chars = new char[512];
        while (!eof) {
            try {
                int len = br.read(chars);
                if (len < 0) {
                    eof = true;
                    continue;
                }
                this.m_input.append(chars, 0, len);
            }
            catch (IOException e) {}
        }
        this.m_literals.put("TRUE", new Integer(21));
        this.m_literals.put("FALSE", new Integer(22));
        this.m_literals.put("and", new Integer(18));
        this.m_literals.put("not", new Integer(6));
        this.m_literals.put("or", new Integer(19));
        this.m_literals.put("exist", new Integer(4));
        this.m_literals.put("in", new Integer(11));
        this.m_literals.put("min", new Integer(25));
        this.m_literals.put("max", new Integer(26));
        this.m_literals.put("with", new Integer(27));
        this.m_literals.put("random", new Integer(28));
        this.m_literals.put("first", new Integer(29));
        this.nextToken();
    }

    public void nextToken() {
        int result = 0;
        boolean done = false;
        this.clearLexeme();
        block21: while (!done) {
            String lexeme;
            Integer val;
            char c = this.nextChar();
            if (this.eof()) {
                result = 1;
                break;
            }
            switch (c) {
                case '(': {
                    result = 2;
                    done = true;
                    this.addLexeme(c);
                    break;
                }
                case ')': {
                    result = 3;
                    done = true;
                    this.addLexeme(c);
                    break;
                }
                case '-': {
                    result = 5;
                    done = true;
                    this.addLexeme(c);
                    break;
                }
                case '*': {
                    result = 7;
                    done = true;
                    this.addLexeme(c);
                    break;
                }
                case '/': {
                    result = 8;
                    done = true;
                    this.addLexeme(c);
                    break;
                }
                case '+': {
                    result = 9;
                    done = true;
                    this.addLexeme(c);
                    break;
                }
                case '~': {
                    result = 10;
                    done = true;
                    this.addLexeme(c);
                    break;
                }
                case '=': {
                    char peek = this.nextChar();
                    if (peek == '=') {
                        this.addLexeme(c);
                        this.addLexeme(peek);
                        result = 12;
                    } else {
                        this.pushBack(peek);
                        result = 0;
                    }
                    done = true;
                    break;
                }
                case '!': {
                    char peek = this.nextChar();
                    if (peek == '=') {
                        this.addLexeme(c);
                        this.addLexeme(peek);
                        result = 13;
                    } else {
                        result = 0;
                    }
                    done = true;
                    break;
                }
                case '<': {
                    char peek = this.nextChar();
                    this.addLexeme(c);
                    if (peek == '=') {
                        this.addLexeme(peek);
                        result = 15;
                    } else {
                        this.pushBack(peek);
                        result = 14;
                    }
                    done = true;
                    break;
                }
                case '>': {
                    char peek = this.nextChar();
                    this.addLexeme(c);
                    if (peek == '=') {
                        this.addLexeme(peek);
                        result = 17;
                    } else {
                        this.pushBack(peek);
                        result = 16;
                    }
                    done = true;
                    break;
                }
                case '\'': {
                    result = 23;
                    while ((c = this.nextChar()) != '\'') {
                        if (c == '\n') {
                            result = 0;
                            break;
                        }
                        if (c == '\\') {
                            c = this.nextChar();
                        }
                        if (this.eof()) {
                            result = 0;
                            break;
                        }
                        this.addLexeme(c);
                    }
                    done = true;
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    boolean seenExp = false;
                    boolean seenPeriod = false;
                    boolean formatError = false;
                    char lastChar = '\u0000';
                    while (!done) {
                        switch (c) {
                            case '.': {
                                if (seenPeriod) {
                                    formatError = true;
                                    done = true;
                                    break;
                                }
                                this.addLexeme(c);
                                seenPeriod = true;
                                break;
                            }
                            case 'E': 
                            case 'e': {
                                if (seenExp || !Character.isDigit(lastChar)) {
                                    formatError = true;
                                    done = true;
                                    break;
                                }
                                seenExp = true;
                                this.addLexeme(c);
                                c = this.nextChar();
                                if (c == '+' || c == '-') {
                                    this.addLexeme(c);
                                    break;
                                }
                                this.pushBack(c);
                                break;
                            }
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                this.addLexeme(c);
                                break;
                            }
                            default: {
                                this.pushBack(c);
                                done = true;
                            }
                        }
                        if (done) continue;
                        lastChar = c;
                        c = this.nextChar();
                        if (!this.eof()) continue;
                        done = true;
                    }
                    if (formatError) break;
                    if (!Character.isDigit(lastChar)) {
                        result = 0;
                        break;
                    }
                    result = 24;
                    break;
                }
                case '\t': 
                case '\n': 
                case ' ': {
                    continue block21;
                }
            }
            if (done) continue;
            if (c != '_' && !Character.isLetter(c)) {
                result = 0;
                done = true;
                continue;
            }
            while (this.isIdent(c) && !this.eof()) {
                this.addLexeme(c);
                c = this.nextChar();
            }
            if (!this.eof()) {
                this.pushBack(c);
            }
            result = (val = (Integer)this.m_literals.get(lexeme = this.getLexeme())) == null ? 20 : val;
            done = true;
        }
        this.m_token = result;
    }

    public int getToken() {
        return this.m_token;
    }

    public String getLexeme() {
        if (this.m_lexeme == null) {
            this.m_lexeme = this.m_buffer.toString();
        }
        return this.m_lexeme;
    }

    public int getPosition() {
        return this.m_pos;
    }

    protected boolean eof() {
        return this.m_eof;
    }

    protected char nextChar() {
        char result = '\u0000';
        if (this.m_pos < this.m_input.length()) {
            result = this.m_input.charAt(this.m_pos);
            ++this.m_pos;
        } else {
            this.m_eof = true;
        }
        return result;
    }

    protected void pushBack(char c) {
        if (c != '\u0000') {
            --this.m_pos;
        }
    }

    protected boolean isIdent(char c) {
        return Character.isLetter(c) || Character.isDigit(c) || c == '_';
    }

    protected void clearLexeme() {
        this.m_lexeme = null;
        this.m_buffer.setLength(0);
    }

    protected void addLexeme(char c) {
        this.m_buffer.append(c);
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Usage: Lex expr");
            System.exit(1);
        }
        Lex lex = new Lex(new StringReader(args[0]));
        int token = lex.getToken();
        while (token != 1 && token != 0) {
            System.out.println("Token = '" + lex.getLexeme() + "' (" + Lex.tokenName(token) + ")");
            lex.nextToken();
            token = lex.getToken();
        }
        System.out.println("Token = " + Lex.tokenName(token));
    }

    protected static String tokenName(int token) {
        String result;
        switch (token) {
            case 0: {
                result = "ERROR";
                break;
            }
            case 1: {
                result = "END";
                break;
            }
            case 2: {
                result = "LPAREN";
                break;
            }
            case 3: {
                result = "RPAREN";
                break;
            }
            case 4: {
                result = "EXIST";
                break;
            }
            case 5: {
                result = "MINUS";
                break;
            }
            case 6: {
                result = "NOT";
                break;
            }
            case 7: {
                result = "MULT";
                break;
            }
            case 8: {
                result = "DIV";
                break;
            }
            case 9: {
                result = "PLUS";
                break;
            }
            case 10: {
                result = "TILDE";
                break;
            }
            case 11: {
                result = "IN";
                break;
            }
            case 12: {
                result = "EQUAL";
                break;
            }
            case 13: {
                result = "NOT_EQUAL";
                break;
            }
            case 14: {
                result = "LESS";
                break;
            }
            case 15: {
                result = "LESS_EQUAL";
                break;
            }
            case 16: {
                result = "GREATER";
                break;
            }
            case 17: {
                result = "GREATER_EQUAL";
                break;
            }
            case 18: {
                result = "AND";
                break;
            }
            case 19: {
                result = "OR";
                break;
            }
            case 20: {
                result = "IDENT";
                break;
            }
            case 21: {
                result = "TRUE_LIT";
                break;
            }
            case 22: {
                result = "FALSE_LIT";
                break;
            }
            case 23: {
                result = "STRING_LIT";
                break;
            }
            case 24: {
                result = "NUMBER_LIT";
                break;
            }
            case 25: {
                result = "PREF_MIN";
                break;
            }
            case 26: {
                result = "PREF_MAX";
                break;
            }
            case 27: {
                result = "PREF_WITH";
                break;
            }
            case 28: {
                result = "PREF_RANDOM";
                break;
            }
            case 29: {
                result = "PREF_FIRST";
                break;
            }
            default: {
                result = "<unknown>";
            }
        }
        return result;
    }
}

