/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.constraint;

import java.io.PrintStream;
import org.jacorb.trading.constraint.ExprNode;
import org.jacorb.trading.constraint.MissingPropertyException;
import org.jacorb.trading.constraint.PropertySource;
import org.jacorb.trading.constraint.Value;
import org.jacorb.trading.constraint.ValueFactory;
import org.jacorb.trading.constraint.ValueType;

public class AndNode
extends ExprNode {
    private ExprNode m_left;
    private ExprNode m_right;

    private AndNode() {
    }

    public AndNode(ExprNode left, ExprNode right) {
        this.m_left = left;
        this.m_right = right;
        this.setType(new ValueType(0));
    }

    public void print(PrintStream ps) {
        ps.println("AndNode: type = " + this.getType());
        ps.println("Left node:");
        this.m_left.print(ps);
        ps.println("Right node:");
        this.m_right.print(ps);
    }

    public Value evaluate(PropertySource source) throws MissingPropertyException {
        Value result = null;
        int id = this.getType().getId();
        Value left = this.m_left.evaluate(source);
        Boolean l = (Boolean)left.getValue();
        if (l.booleanValue()) {
            Value right = this.m_right.evaluate(source);
            Boolean r = (Boolean)right.getValue();
            result = ValueFactory.createBoolean(r);
        } else {
            result = ValueFactory.createBoolean(false);
        }
        return result;
    }
}

