/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.client.typemgr;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import org.jacorb.trading.client.typemgr.AddTypeDialog;
import org.jacorb.trading.client.util.ConfirmDialog;
import org.jacorb.trading.client.util.Constrain;
import org.jacorb.trading.client.util.QuickSort;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CosTrading.IllegalServiceType;
import org.omg.CosTrading.Lookup;
import org.omg.CosTrading.LookupHelper;
import org.omg.CosTrading.UnknownServiceType;
import org.omg.CosTradingRepos.ServiceTypeRepository;
import org.omg.CosTradingRepos.ServiceTypeRepositoryHelper;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.AlreadyMasked;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.HasSubTypes;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.NotMasked;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.SpecifiedServiceTypes;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.TypeStruct;

public class TypeManager
extends Frame
implements ActionListener,
ItemListener,
Runnable {
    private List m_types;
    private TextArea m_description;
    private Button m_add;
    private Button m_remove;
    private Checkbox m_masked;
    private Label m_incarnation;
    private Label m_status;
    private AddTypeDialog m_addDialog;
    private ServiceTypeRepository m_repos;
    private static ORB s_orb;

    public TypeManager(ServiceTypeRepository repos) {
        super("Service Type Repository");
        this.setFont(new Font("Helvetica", 0, 12));
        this.m_repos = repos;
        this.createContents();
        this.refreshTypes();
    }

    protected void createContents() {
        Panel panel = new Panel();
        panel.setLayout(new GridBagLayout());
        Panel typesPanel = new Panel();
        typesPanel.setLayout(new GridBagLayout());
        Constrain.constrain(typesPanel, new Label("Service types", 0), 0, 0, 1, 1, 0, 18, 0.0, 0.0, 0, 0, 0, 0);
        this.m_types = new List();
        this.m_types.setMultipleMode(false);
        this.m_types.setSize(this.m_types.getMinimumSize(10));
        this.m_types.addItemListener(this);
        Constrain.constrain(typesPanel, this.m_types, 0, 1, 1, 1, 1, 18, 1.0, 1.0, 0, 0, 0, 0);
        Constrain.constrain(panel, typesPanel, 0, 0, 1, 1, 1, 18, 0.25, 1.0, 5, 10, 5, 5);
        Panel descPanel = new Panel();
        descPanel.setLayout(new GridBagLayout());
        Constrain.constrain(descPanel, new Label("Description", 0), 0, 0, 2, 1, 0, 18, 0.0, 0.0, 0, 0, 0, 0);
        this.m_description = new TextArea(10, 40);
        this.m_description.setEditable(false);
        Constrain.constrain(descPanel, this.m_description, 0, 1, 2, 1, 1, 18, 1.0, 1.0, 0, 0, 0, 0);
        Constrain.constrain(panel, descPanel, 1, 0, 1, 1, 1, 12, 0.75, 1.0, 5, 5, 5, 10);
        Panel buttonPanel = new Panel();
        buttonPanel.setLayout(new GridLayout(1, 2, 10, 0));
        this.m_add = new Button("Add...");
        this.m_add.setActionCommand("add");
        this.m_add.addActionListener(this);
        buttonPanel.add(this.m_add);
        this.m_remove = new Button("Remove...");
        this.m_remove.setActionCommand("remove");
        this.m_remove.addActionListener(this);
        buttonPanel.add(this.m_remove);
        Constrain.constrain(panel, buttonPanel, 0, 1, 1, 1, 0, 18, 0.0, 0.0, 5, 10, 5, 5);
        Panel maskPanel = new Panel();
        maskPanel.setLayout(new GridBagLayout());
        this.m_masked = new Checkbox(" Masked");
        this.m_masked.addItemListener(this);
        Constrain.constrain(maskPanel, this.m_masked, 0, 2, 1, 1, 0, 18, 0.0, 0.0, 0, 0, 0, 0);
        this.m_incarnation = new Label("Incarnation:", 2);
        Constrain.constrain(maskPanel, this.m_incarnation, 1, 2, 1, 1, 2, 12, 1.0, 0.0, 0, 0, 0, 0);
        Constrain.constrain(panel, maskPanel, 1, 1, 1, 1, 2, 12, 1.0, 0.0, 5, 5, 5, 10);
        this.m_status = new Label("", 0);
        Constrain.constrain(panel, this.m_status, 0, 2, 2, 1, 2, 18, 1.0, 0.0, 0, 10, 3, 10);
        this.add(panel);
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getItemSelectable() == this.m_types) {
            this.updateButtons();
            this.clearStatus();
            if (e.getStateChange() == 1) {
                this.describeType();
            }
        } else if (e.getItemSelectable() == this.m_masked) {
            this.maskType(e.getStateChange() == 1);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("add")) {
            if (this.m_addDialog == null) {
                this.m_addDialog = new AddTypeDialog((Frame)this, this.m_repos);
                this.m_addDialog.setActionCommand("refresh");
                this.m_addDialog.addActionListener(this);
            }
            this.clearStatus();
            this.m_addDialog.setVisible(true);
        } else if (cmd.equals("remove")) {
            String type = this.m_types.getSelectedItem();
            ConfirmDialog confirm = new ConfirmDialog((Frame)this, "Remove type '" + type + "'?");
            confirm.setActionCommand("confirm");
            confirm.addActionListener(this);
            this.clearStatus();
            confirm.setVisible(true);
        } else if (cmd.equals("refresh")) {
            this.refreshTypes();
        } else if (cmd.equals("confirm")) {
            this.removeType();
        }
    }

    protected void removeType() {
        try {
            String type = this.m_types.getSelectedItem();
            this.m_repos.remove_type(type);
            this.m_types.remove(type);
            this.m_description.setText("");
            this.clearStatus();
            this.updateButtons();
        }
        catch (HasSubTypes e) {
            this.showStatus("Service type '" + e.the_type + "' has subtypes");
        }
        catch (IllegalServiceType e) {
            this.showStatus("Illegal service type: " + e.type);
        }
        catch (UnknownServiceType e) {
            this.showStatus("Unknown service type: " + e.type);
        }
    }

    protected void maskType(boolean mask) {
        try {
            String type = this.m_types.getSelectedItem();
            if (mask) {
                this.m_repos.mask_type(type);
            } else {
                this.m_repos.unmask_type(type);
            }
            this.clearStatus();
        }
        catch (NotMasked e) {
            this.showStatus("Service type '" + e.name + "' is not masked");
            this.m_masked.setState(false);
        }
        catch (AlreadyMasked e) {
            this.showStatus("Service type '" + e.name + "' is already masked");
            this.m_masked.setState(true);
        }
        catch (IllegalServiceType e) {
            this.showStatus("Illegal service type: " + e.type);
        }
        catch (UnknownServiceType e) {
            this.showStatus("Unknown service type: " + e.type);
        }
    }

    protected void refreshTypes() {
        new Thread(this).start();
    }

    public void run() {
        this.showStatus("Refreshing service types...");
        SpecifiedServiceTypes whichTypes = new SpecifiedServiceTypes();
        whichTypes.__default();
        String[] types = this.m_repos.list_types(whichTypes);
        QuickSort.sort(types);
        this.m_types.removeAll();
        for (int i = 0; i < types.length; ++i) {
            this.m_types.add(types[i]);
        }
        this.updateButtons();
        this.m_description.setText("");
        this.clearStatus();
    }

    protected void updateButtons() {
        if (this.m_types.getSelectedIndex() < 0) {
            this.m_remove.setEnabled(false);
            this.m_masked.setEnabled(false);
            this.m_incarnation.setText("Incarnation:");
            this.m_incarnation.setEnabled(false);
        } else {
            this.m_remove.setEnabled(true);
            this.m_masked.setEnabled(true);
            this.m_incarnation.setEnabled(true);
        }
    }

    protected void describeType() {
        try {
            String type = this.m_types.getSelectedItem();
            TypeStruct ts = this.m_repos.describe_type(type);
            String script = this.printType(type, ts);
            this.m_description.setText(script);
            this.m_masked.setState(ts.masked);
            this.m_incarnation.setText("Incarnation: {" + ts.incarnation.high + ", " + ts.incarnation.low + "}");
        }
        catch (IllegalServiceType e) {
            this.showStatus("Illegal service type: " + e.type);
        }
        catch (UnknownServiceType e) {
            this.showStatus("Unknown service type: " + e.type);
        }
        catch (SystemException e) {
            this.showStatus("System error occurred");
            e.printStackTrace();
        }
    }

    protected String printType(String name, TypeStruct ts) {
        int i;
        StringBuffer buff = new StringBuffer();
        buff.append("service " + name + " ");
        if (ts.super_types.length > 0) {
            buff.append(": ");
            for (i = 0; i < ts.super_types.length; ++i) {
                buff.append(ts.super_types[i]);
                if (i < ts.super_types.length - 1) {
                    buff.append(", ");
                    continue;
                }
                buff.append(" ");
            }
        }
        buff.append("{\n");
        buff.append("  interface " + ts.if_name + ";\n");
        for (i = 0; i < ts.props.length; ++i) {
            buff.append("  ");
            switch (ts.props[i].mode.value()) {
                case 0: {
                    buff.append("property ");
                    break;
                }
                case 1: {
                    buff.append("readonly property ");
                    break;
                }
                case 2: {
                    buff.append("mandatory property ");
                    break;
                }
                case 3: {
                    buff.append("mandatory readonly property ");
                }
            }
            buff.append(this.convertType(ts.props[i].value_type) + " " + ts.props[i].name + ";\n");
        }
        buff.append("};\n");
        return buff.toString();
    }

    protected String convertType(TypeCode tc) {
        String result = null;
        TCKind kind = tc.kind();
        if (kind == TCKind.tk_sequence) {
            try {
                TypeCode elemTC = tc.content_type();
                kind = elemTC.kind();
                result = "sequence<" + this.convertKind(kind) + ">";
            }
            catch (BadKind e) {
                throw new RuntimeException();
            }
        } else {
            result = this.convertKind(kind);
        }
        return result;
    }

    protected String convertKind(TCKind kind) {
        String result = "unknown";
        switch (kind.value()) {
            case 0: {
                result = "other";
                break;
            }
            case 8: {
                result = "boolean";
                break;
            }
            case 2: {
                result = "short";
                break;
            }
            case 4: {
                result = "unsigned short";
                break;
            }
            case 3: {
                result = "long";
                break;
            }
            case 5: {
                result = "unsigned long";
                break;
            }
            case 6: {
                result = "float";
                break;
            }
            case 7: {
                result = "double";
                break;
            }
            case 9: {
                result = "char";
                break;
            }
            case 18: {
                result = "string";
            }
        }
        return result;
    }

    protected void showStatus(String message) {
        this.m_status.setText(message);
    }

    protected void clearStatus() {
        this.m_status.setText("");
    }

    protected static void usage() {
        System.out.println("Usage: TypeManager iorfile");
        System.exit(1);
    }

    public static void main(String[] args) {
        s_orb = ORB.init(args, null);
        ServiceTypeRepository repos = null;
        try {
            Object obj = s_orb.resolve_initial_references("TradingService");
            if (obj == null) {
                System.out.println("Invalid object");
                System.exit(1);
            }
            Lookup lookup = LookupHelper.narrow(obj);
            obj = lookup.type_repos();
            repos = ServiceTypeRepositoryHelper.narrow(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        TypeManager app = new TypeManager(repos);
        app.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                e.getWindow().dispose();
                System.exit(0);
            }
        });
        app.pack();
        app.setVisible(true);
    }
}

