/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.client.typemgr;

import java.io.Reader;
import java.util.Enumeration;
import java.util.Vector;
import org.jacorb.trading.client.typemgr.Lex;
import org.jacorb.trading.client.typemgr.LexException;
import org.jacorb.trading.client.typemgr.ParserException;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.PropStruct;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.PropertyMode;

public class Parser {
    private Lex m_lex;
    private String m_currentIdent;
    private String m_currentScopedName;
    private String m_name;
    private String m_interface;
    private PropStruct m_currentProperty;
    private PropStruct[] m_properties;
    private String[] m_superTypes;

    public void parse(Reader reader) throws ParserException {
        this.m_currentProperty = new PropStruct();
        try {
            this.m_lex = new Lex(reader);
            this.m_lex.nextToken();
            if (this.m_lex.getToken() == 1) {
                throw new ParserException("no input", 0);
            }
            this.parseService();
        }
        catch (LexException e) {
            throw new ParserException("Lexical error: " + e.getMessage(), e.getLine());
        }
    }

    public String getName() {
        return this.m_name;
    }

    public String getInterface() {
        return this.m_interface;
    }

    public PropStruct[] getProperties() {
        return this.m_properties;
    }

    public String[] getSuperTypes() {
        return this.m_superTypes;
    }

    protected void parseService() throws ParserException, LexException {
        int t = this.m_lex.getToken();
        if (t == 10) {
            this.m_lex.nextToken();
            this.parseScopedName();
            this.m_name = this.m_currentScopedName;
            this.parseBaseTypes();
            if (this.m_lex.getToken() != 2) {
                throw new ParserException("expected '{' symbol", this.m_lex.getLine());
            }
            this.m_lex.nextToken();
            if (this.m_lex.getToken() != 11) {
                throw new ParserException("expected 'interface' declaration", this.m_lex.getLine());
            }
            this.m_lex.nextToken();
            this.parseScopedName();
            this.m_interface = this.m_currentScopedName;
            if (this.m_lex.getToken() != 8) {
                throw new ParserException("expected ';' after 'interface' declaration", this.m_lex.getLine());
            }
            this.m_lex.nextToken();
            this.parsePropertyList();
            if (this.m_lex.getToken() != 3) {
                throw new ParserException("expected '}' symbol", this.m_lex.getLine());
            }
            this.m_lex.nextToken();
            if (this.m_lex.getToken() != 8) {
                throw new ParserException("expected ';' after 'service' declaration", this.m_lex.getLine());
            }
        } else {
            throw new ParserException("expected 'service' declaration", this.m_lex.getLine());
        }
        this.m_lex.nextToken();
    }

    protected void parseBaseTypes() throws ParserException, LexException {
        Vector<String> superTypes = new Vector<String>();
        int t = this.m_lex.getToken();
        if (t == 6) {
            this.m_lex.nextToken();
            this.parseScopedName();
            superTypes.addElement(this.m_currentScopedName);
            while (this.m_lex.getToken() == 9) {
                this.m_lex.nextToken();
                this.parseScopedName();
                superTypes.addElement(this.m_currentScopedName);
            }
        }
        this.m_superTypes = new String[superTypes.size()];
        superTypes.copyInto(this.m_superTypes);
    }

    protected void parseScopedName() throws ParserException, LexException {
        int t = this.m_lex.getToken();
        if (t != 12 && t != 7) {
            throw new ParserException("expected scoped identifier", this.m_lex.getLine());
        }
        boolean seenIdent = false;
        StringBuffer name = new StringBuffer();
        int lastToken = t;
        while (t == 12 || t == 7) {
            name.append(this.m_lex.getLexeme());
            if (t == 12) {
                seenIdent = true;
            }
            lastToken = t;
            this.m_lex.nextToken();
            t = this.m_lex.getToken();
            if (t != 7 || lastToken != 7) continue;
            throw new ParserException("malformed scoped identifier", this.m_lex.getLine());
        }
        if (!seenIdent || lastToken == 7) {
            throw new ParserException("malformed scoped identifier", this.m_lex.getLine());
        }
        this.m_currentScopedName = name.toString();
    }

    protected void parseIdent() throws ParserException, LexException {
        int t = this.m_lex.getToken();
        if (t == 12) {
            this.m_currentIdent = this.m_lex.getLexeme();
            this.m_lex.nextToken();
        }
    }

    protected void parsePropertyList() throws ParserException, LexException {
        Vector<PropStruct> props = new Vector<PropStruct>();
        int t = this.m_lex.getToken();
        while (t != 3) {
            this.parseProperty();
            props.addElement(new PropStruct(this.m_currentProperty.name, this.m_currentProperty.value_type, this.m_currentProperty.mode));
            t = this.m_lex.getToken();
        }
        this.m_properties = new PropStruct[props.size()];
        Enumeration e = props.elements();
        int count = 0;
        while (e.hasMoreElements()) {
            this.m_properties[count++] = (PropStruct)e.nextElement();
        }
    }

    protected void parseProperty() throws ParserException, LexException {
        this.m_currentProperty.mode = PropertyMode.PROP_NORMAL;
        this.parseQualifierList();
        int t = this.m_lex.getToken();
        if (t == 15) {
            this.m_lex.nextToken();
            this.parseIDLType();
            if (this.m_lex.getToken() != 12) {
                throw new ParserException("expected property identifier after IDL type", this.m_lex.getLine());
            }
            this.parseIdent();
            this.m_currentProperty.name = this.m_currentIdent;
            if (this.m_lex.getToken() != 8) {
                throw new ParserException("expected ';' after property declaration", this.m_lex.getLine());
            }
        } else {
            throw new ParserException("invalid property declaration", this.m_lex.getLine());
        }
        this.m_lex.nextToken();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parseQualifierList() throws ParserException, LexException {
        int t = this.m_lex.getToken();
        while (t == 13 || t == 14) {
            PropertyMode mode = this.m_currentProperty.mode;
            if (t == 13) {
                if (mode == PropertyMode.PROP_NORMAL) {
                    mode = PropertyMode.PROP_MANDATORY;
                } else {
                    if (mode != PropertyMode.PROP_READONLY) throw new ParserException("duplicate 'mandatory' qualifier", this.m_lex.getLine());
                    mode = PropertyMode.PROP_MANDATORY_READONLY;
                }
            } else if (t == 14) {
                if (mode == PropertyMode.PROP_NORMAL) {
                    mode = PropertyMode.PROP_READONLY;
                } else {
                    if (mode != PropertyMode.PROP_MANDATORY) throw new ParserException("duplicate 'readonly' qualifier", this.m_lex.getLine());
                    mode = PropertyMode.PROP_MANDATORY_READONLY;
                }
            }
            this.m_currentProperty.mode = mode;
            this.m_lex.nextToken();
            t = this.m_lex.getToken();
        }
    }

    protected void parseIDLType() throws ParserException, LexException {
        int t = this.m_lex.getToken();
        if (t == 24) {
            this.m_lex.nextToken();
            if (this.m_lex.getToken() != 4) {
                throw new ParserException("expected '<' after 'sequence'", this.m_lex.getLine());
            }
            this.m_lex.nextToken();
            this.parseType(true);
            if (this.m_lex.getToken() != 5) {
                throw new ParserException("expected '>' after sequence type", this.m_lex.getLine());
            }
            this.m_lex.nextToken();
        } else if (t == 25) {
            this.m_currentProperty.value_type = ORB.init().get_primitive_tc(TCKind.tk_null);
            this.m_lex.nextToken();
        } else {
            this.parseType(false);
        }
    }

    protected void parseType(boolean seq) throws ParserException, LexException {
        ORB orb = ORB.init();
        int t = this.m_lex.getToken();
        switch (t) {
            case 16: {
                this.m_lex.nextToken();
                t = this.m_lex.getToken();
                if (t == 19) {
                    TypeCode shortTC = orb.get_primitive_tc(TCKind.tk_short);
                    this.m_currentProperty.value_type = seq ? orb.create_sequence_tc(0, shortTC) : shortTC;
                    this.m_lex.nextToken();
                    break;
                }
                if (t == 20) {
                    TypeCode ulongTC = orb.get_primitive_tc(TCKind.tk_ulong);
                    this.m_currentProperty.value_type = seq ? orb.create_sequence_tc(0, ulongTC) : ulongTC;
                    this.m_lex.nextToken();
                    break;
                }
                throw new ParserException("only short and long can be unsigned", this.m_lex.getLine());
            }
            case 18: {
                TypeCode charTC = orb.get_primitive_tc(TCKind.tk_char);
                this.m_currentProperty.value_type = seq ? orb.create_sequence_tc(0, charTC) : charTC;
                this.m_lex.nextToken();
                break;
            }
            case 17: {
                TypeCode booleanTC = orb.get_primitive_tc(TCKind.tk_boolean);
                this.m_currentProperty.value_type = seq ? orb.create_sequence_tc(0, booleanTC) : booleanTC;
                this.m_lex.nextToken();
                break;
            }
            case 19: {
                TypeCode shortTC = orb.get_primitive_tc(TCKind.tk_short);
                this.m_currentProperty.value_type = seq ? orb.create_sequence_tc(0, shortTC) : shortTC;
                this.m_lex.nextToken();
                break;
            }
            case 20: {
                TypeCode longTC = orb.get_primitive_tc(TCKind.tk_long);
                this.m_currentProperty.value_type = seq ? orb.create_sequence_tc(0, longTC) : longTC;
                this.m_lex.nextToken();
                break;
            }
            case 21: {
                TypeCode floatTC = orb.get_primitive_tc(TCKind.tk_float);
                this.m_currentProperty.value_type = seq ? orb.create_sequence_tc(0, floatTC) : floatTC;
                this.m_lex.nextToken();
                break;
            }
            case 22: {
                TypeCode doubleTC = orb.get_primitive_tc(TCKind.tk_double);
                this.m_currentProperty.value_type = seq ? orb.create_sequence_tc(0, doubleTC) : doubleTC;
                this.m_lex.nextToken();
                break;
            }
            case 23: {
                TypeCode stringTC = orb.get_primitive_tc(TCKind.tk_string);
                this.m_currentProperty.value_type = seq ? orb.create_sequence_tc(0, stringTC) : stringTC;
                this.m_lex.nextToken();
                break;
            }
            default: {
                throw new ParserException("unknown/unsupported IDL type '" + this.m_lex.getLexeme() + "'", this.m_lex.getLine());
            }
        }
    }
}

