/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.poa.AOM;
import org.jacorb.poa.POA;
import org.jacorb.poa.POAAdapter;
import org.jacorb.poa.POAMonitor;
import org.jacorb.poa.RPPoolManager;
import org.jacorb.poa.RequestProcessor;
import org.jacorb.poa.RequestQueue;
import org.jacorb.poa.except.ApplicationError;
import org.jacorb.poa.gui.POAMonitorController;
import org.jacorb.poa.gui.POAMonitorView;
import org.jacorb.poa.gui.poa.POAFrame;
import org.jacorb.poa.util.POAUtil;
import org.jacorb.poa.util.StringPair;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.PortableServer.Servant;

public class POAMonitorImpl
extends POAAdapter
implements POAMonitor,
POAMonitorController,
Configurable {
    private POA poaModel;
    private AOM aomModel;
    private RequestQueue queueModel;
    private RPPoolManager pmModel;
    private POAMonitorView view;
    private String prefix;
    private int aomSize;
    private int queueSize;
    private int poolCount;
    private int poolSize;
    private boolean terminate;
    private boolean aomChanged;
    private boolean queueChanged;
    private boolean pmChanged;
    private org.jacorb.config.Configuration configuration = null;
    private Logger logger;
    private int threadPoolMin = 0;
    private int threadPoolMax = 0;

    public void configure(Configuration myConfiguration) throws ConfigurationException {
        this.configuration = (org.jacorb.config.Configuration)myConfiguration;
        this.logger = this.configuration.getNamedLogger("jacorb.poa.monitor");
        this.threadPoolMin = this.configuration.getAttributeAsInteger("jacorb.poa.thread_pool_min", 5);
        this.threadPoolMax = this.configuration.getAttributeAsInteger("jacorb.poa.thread_pool_max", 20);
    }

    public void actionCloseView() {
        this.closeMonitor();
    }

    public void actionDeactivateObject(String oidStr) {
        if (this.poaModel != null) {
            try {
                this.poaModel.deactivate_object(oidStr.getBytes());
            }
            catch (Throwable e) {
                this.printMessage("Exception occurred in deactivateObject() of POAMonitor: " + e);
            }
        }
    }

    public void actionRemoveRequestFromQueue(String ridStr) {
        if (this.queueModel != null && this.poaModel != null) {
            try {
                ServerRequest request = this.queueModel.getElementAndRemove(Integer.parseInt(ridStr));
                if (request == null) {
                    throw new ApplicationError("error: rid " + ridStr + " is not contained in queue");
                }
                this.poaModel.getRequestController().rejectRequest(request, new OBJ_ADAPTER());
            }
            catch (Throwable e) {
                this.printMessage("Exception occurred in removeRequestFromQueue() of POAMonitor: " + e);
            }
        }
    }

    public StringPair[] actionRetrieveAOMContent() {
        if (this.aomModel != null) {
            try {
                return this.aomModel != null ? this.aomModel.deliverContent() : null;
            }
            catch (Throwable e) {
                this.printMessage("Exception occurred in retrieveAOMContent() of POAMonitor: " + e);
            }
        }
        return null;
    }

    public StringPair[] actionRetrieveQueueContent() {
        if (this.queueModel != null) {
            try {
                return this.queueModel.deliverContent();
            }
            catch (Throwable e) {
                this.printMessage("Exception during retrieveQueueContent() of POAMonitor: " + e);
            }
        }
        return null;
    }

    public synchronized void changeState(String state) {
        block3: {
            if (this.view != null) {
                try {
                    this.view._setState(state);
                }
                catch (Throwable exception) {
                    if (!this.logger.isWarnEnabled()) break block3;
                    this.logger.warn("Exception during changeState() of POAMonitor" + exception.getMessage());
                }
            }
        }
    }

    public synchronized void closeMonitor() {
        block3: {
            if (this.view != null) {
                try {
                    this.terminate = true;
                    this.poaModel._removePOAEventListener(this);
                    POAMonitor newMonitor = (POAMonitor)Class.forName("org.jacorb.poa.POAMonitorLightImpl").newInstance();
                    newMonitor.init(this.poaModel, this.aomModel, this.queueModel, this.pmModel, this.prefix);
                    newMonitor.configure(this.configuration);
                    this.poaModel.setMonitor(newMonitor);
                    POAMonitorView tmp = this.view;
                    this.view = null;
                    tmp._destroy();
                }
                catch (Throwable exception) {
                    if (!this.logger.isWarnEnabled()) break block3;
                    this.logger.warn("Exception during closeMonitor() of POAMonitorImpl" + exception.getMessage());
                }
            }
        }
    }

    public void init(POA poa, AOM aom, RequestQueue queue, RPPoolManager pm, String _prefix) {
        this.poaModel = poa;
        this.aomModel = aom;
        this.queueModel = queue;
        this.pmModel = pm;
        this.prefix = this.prefix;
    }

    private void initView() {
        block3: {
            if (this.view != null) {
                try {
                    String name = this.poaModel._getQualifiedName();
                    this.view._setName(name.equals("") ? "RootPOA" : "RootPOA/" + name);
                    this.view._setState(POAUtil.convert(this.poaModel.getState()));
                    this.view._setPolicyThread(POAUtil.convert(this.poaModel.threadPolicy, 16));
                    this.view._setPolicyLifespan(POAUtil.convert(this.poaModel.lifespanPolicy, 17));
                    this.view._setPolicyIdUniqueness(POAUtil.convert(this.poaModel.idUniquenessPolicy, 18));
                    this.view._setPolicyIdAssignment(POAUtil.convert(this.poaModel.idAssignmentPolicy, 19));
                    this.view._setPolicyServantRetention(POAUtil.convert(this.poaModel.servantRetentionPolicy, 21));
                    this.view._setPolicyRequestProcessing(POAUtil.convert(this.poaModel.requestProcessingPolicy, 22));
                    this.view._setPolicyImplicitActivation(POAUtil.convert(this.poaModel.implicitActivationPolicy, 20));
                    this.view._initAOMBar(this.aomModel != null ? 10 : 0, true);
                    this.view._initQueueBar(10, true);
                    this.view._initActiveRequestsBar(this.poaModel.isSingleThreadModel() ? 1 : this.threadPoolMin, this.poaModel.isSingleThreadModel() ? 1 : this.threadPoolMax);
                    this.view._initThreadPoolBar(0);
                }
                catch (Throwable exception) {
                    if (!this.logger.isWarnEnabled()) break block3;
                    this.logger.warn("Exception during initView() of POAMonitor" + exception.getMessage());
                }
            }
        }
    }

    public void objectActivated(byte[] oid, Servant servant, int aom_size) {
        this.aomSize = aom_size;
        this.aomChanged = true;
        this.refreshAOM();
    }

    public void objectDeactivated(byte[] oid, Servant servant, int aom_size) {
        this.aomSize = aom_size;
        this.aomChanged = true;
        this.refreshAOM();
    }

    public synchronized void openMonitor() {
        block3: {
            if (this.view == null) {
                try {
                    this.aomSize = this.aomModel != null ? this.aomModel.size() : 0;
                    this.queueSize = this.queueModel.size();
                    this.poolCount = this.pmModel.getPoolCount();
                    this.poolSize = this.pmModel.getPoolSize();
                    this.view = new POAFrame(this);
                    this.initView();
                    this.refreshView();
                    this.poaModel._addPOAEventListener(this);
                    this.view._setVisible(true);
                }
                catch (Throwable exception) {
                    if (!this.logger.isWarnEnabled()) break block3;
                    this.logger.warn("Exception occurred in openMonitor() of POAMonitor" + exception.getMessage());
                }
            }
        }
    }

    private synchronized void printException(Throwable e) {
        if (this.view != null) {
            try {
                this.view._printMessage("####################################################################");
                this.view._printMessage("\t" + e);
                this.view._printMessage("####################################################################");
            }
            catch (Throwable exception) {
                System.err.println("Exception occurred in _printException() of POAMonitor");
            }
        }
    }

    private synchronized void printMessage(String str) {
        if (this.view != null) {
            try {
                this.view._printMessage(str);
            }
            catch (Throwable exception) {
                System.err.println("Exception occurred in _printMessage() of POAMonitor");
            }
        }
    }

    public void processorAddedToPool(RequestProcessor processor, int pool_count, int pool_size) {
        this.poolCount = pool_count;
        this.poolSize = pool_size;
        this.pmChanged = true;
        this.refreshPM();
    }

    public void processorRemovedFromPool(RequestProcessor processor, int pool_count, int pool_size) {
        this.poolCount = pool_count;
        this.poolSize = pool_size;
        this.pmChanged = true;
        this.refreshPM();
    }

    private void refreshAOM() {
        block3: {
            if (this.view != null) {
                try {
                    this.view._setValueAOMBar(this.aomSize);
                }
                catch (Throwable exception) {
                    if (!this.logger.isWarnEnabled()) break block3;
                    this.logger.warn("Exception during refreshAOM() of POAMonitor" + exception.getMessage());
                }
            }
        }
    }

    private void refreshPM() {
        block3: {
            if (this.view != null) {
                try {
                    this.view._setValueActiveRequestsBar(this.poolSize - this.poolCount);
                    this.view._setMaxThreadPoolBar(this.poolSize);
                    this.view._setValueThreadPoolBar(this.poolCount);
                }
                catch (Throwable exception) {
                    if (!this.logger.isWarnEnabled()) break block3;
                    this.logger.warn("Exception occurred in refreshPM() of POAMonitor" + exception.getMessage());
                }
            }
        }
    }

    private void refreshQueue() {
        block3: {
            if (this.view != null) {
                try {
                    this.view._setValueQueueBar(this.queueSize);
                }
                catch (Throwable exception) {
                    if (!this.logger.isWarnEnabled()) break block3;
                    this.logger.warn("Exception occurred in refreshQueue() of POAMonitor: " + exception.getMessage());
                }
            }
        }
    }

    private void refreshView() {
        this.refreshAOM();
        this.refreshQueue();
        this.refreshPM();
    }

    public void requestAddedToQueue(ServerRequest request, int queue_size) {
        this.queueSize = queue_size;
        this.queueChanged = true;
        this.refreshQueue();
    }

    public void requestRemovedFromQueue(ServerRequest request, int queue_size) {
        this.queueSize = queue_size;
        this.queueChanged = true;
        this.refreshQueue();
    }
}

