/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.standardInterceptors;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.ORB;
import org.jacorb.orb.giop.CodeSet;
import org.omg.CONV_FRAME.CodeSetComponent;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.omg.CONV_FRAME.CodeSetComponentInfoHelper;
import org.omg.CORBA.LocalObject;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.IORInfo;
import org.omg.PortableInterceptor.IORInterceptor;

public class CodeSetInfoInterceptor
extends LocalObject
implements IORInterceptor,
Configurable {
    private TaggedComponent tagc = null;
    private Logger logger = null;

    public CodeSetInfoInterceptor(ORB orb) {
        try {
            this.configure(orb.getConfiguration());
        }
        catch (ConfigurationException ex) {
            // empty catch block
        }
        CodeSetComponentInfo cs_info = new CodeSetComponentInfo();
        cs_info.ForCharData = new CodeSetComponent(CodeSet.getTCSDefault(), new int[]{CodeSet.getConversionDefault()});
        cs_info.ForWcharData = new CodeSetComponent(CodeSet.getTCSWDefault(), new int[]{0x5010001});
        CDROutputStream os = new CDROutputStream(orb);
        os.beginEncapsulatedArray();
        CodeSetComponentInfoHelper.write(os, cs_info);
        this.tagc = new TaggedComponent(1, os.getBufferCopy());
        os.close();
        os = null;
        cs_info = null;
    }

    public void configure(Configuration config) throws ConfigurationException {
        org.jacorb.config.Configuration cfg = (org.jacorb.config.Configuration)config;
        this.logger = cfg.getNamedLogger("org.jacorb.interceptors.ior_init");
        String ncsc = config.getAttribute("jacorb.native_char_codeset", "ISO-8859-1");
        String ncsw = config.getAttribute("jacorb.native_wchar_codeset", "UTF-16");
        if (CodeSet.setNCSC(ncsc) == -1 && this.logger.isErrorEnabled()) {
            this.logger.error("Cannot set default NCSC to " + ncsc);
        }
        if (CodeSet.setNCSW(ncsw) == -1 && this.logger.isErrorEnabled()) {
            this.logger.error("Cannot set default NCSW to " + ncsw);
        }
    }

    public String name() {
        return "CodeSetInfoComponentCreator";
    }

    public void destroy() {
    }

    public void establish_components(IORInfo info, int[] tags) {
        if (tags == null) {
            info.add_ior_component_to_profile(this.tagc, 1);
            info.add_ior_component_to_profile(this.tagc, 0);
        } else {
            for (int i = 0; i < tags.length; ++i) {
                info.add_ior_component_to_profile(this.tagc, tags[i]);
            }
        }
    }

    public void establish_components(IORInfo info) {
        info.add_ior_component_to_profile(this.tagc, 1);
        info.add_ior_component_to_profile(this.tagc, 0);
    }
}

