/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.iiop;

import java.util.List;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.TaggedComponentList;
import org.jacorb.orb.etf.ProfileBase;
import org.jacorb.orb.etf.ProtocolAddressBase;
import org.jacorb.orb.iiop.IIOPAddress;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.CSIIOP.TLS_SEC_TRANS;
import org.omg.CSIIOP.TLS_SEC_TRANSHelper;
import org.omg.ETF.Profile;
import org.omg.GIOP.Version;
import org.omg.GIOP.VersionHelper;
import org.omg.IOP.TaggedComponent;
import org.omg.SSLIOP.SSL;
import org.omg.SSLIOP.SSLHelper;

public class IIOPProfile
extends ProfileBase {
    private IIOPAddress primaryAddress = null;
    private Logger logger;
    static /* synthetic */ Class class$org$jacorb$orb$iiop$IIOPAddress;
    static /* synthetic */ Class class$org$omg$SSLIOP$SSLHelper;
    static /* synthetic */ Class class$org$omg$CSIIOP$CompoundSecMechListHelper;

    public IIOPProfile() {
    }

    public IIOPProfile(byte[] data) {
        this.initFromProfileData(data);
    }

    public IIOPProfile(IIOPAddress address, byte[] objectKey) {
        this.version = new Version(1, 2);
        this.primaryAddress = address;
        this.objectKey = objectKey;
        this.components = new TaggedComponentList();
    }

    public IIOPProfile(IIOPAddress address, byte[] objectKey, int minor) {
        this.version = new Version(1, (byte)minor);
        this.primaryAddress = address;
        this.objectKey = objectKey;
        this.components = new TaggedComponentList();
    }

    public IIOPProfile(String corbaloc) {
        this.version = null;
        this.primaryAddress = null;
        this.objectKey = null;
        this.components = null;
        this.corbalocStr = corbaloc;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = (org.jacorb.config.Configuration)configuration;
        this.logger = this.configuration.getNamedLogger("jacorb.iiop.profile");
        if (this.primaryAddress != null) {
            this.primaryAddress.configure(configuration);
        }
        if (this.corbalocStr != null) {
            try {
                this.decode_corbaloc(this.corbalocStr);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void decode_corbaloc(String addr) {
        String protocol_identifier;
        block11: {
            String host = "127.0.0.1";
            int port = 2809;
            int major = 1;
            int minor = 2;
            String errorstr = "Illegal IIOP protocol format in object address format: " + addr;
            int sep = addr.indexOf(58);
            protocol_identifier = "";
            if (sep != 0) {
                protocol_identifier = addr.substring(0, sep);
            }
            if (sep + 1 == addr.length()) {
                throw new IllegalArgumentException(errorstr);
            }
            if ((sep = (addr = addr.substring(sep + 1)).indexOf(64)) > -1) {
                String ver_str = addr.substring(0, sep);
                addr = addr.substring(sep + 1);
                sep = ver_str.indexOf(46);
                if (sep != -1) {
                    try {
                        major = Integer.parseInt(ver_str.substring(0, sep));
                        minor = Integer.parseInt(ver_str.substring(sep + 1));
                    }
                    catch (NumberFormatException nfe) {
                        throw new IllegalArgumentException(errorstr);
                    }
                }
            }
            this.version = new Version((byte)major, (byte)minor);
            sep = addr.indexOf(58);
            if (sep != -1) {
                try {
                    port = (short)Integer.parseInt(addr.substring(sep + 1));
                    host = addr.substring(0, sep);
                }
                catch (NumberFormatException ill) {
                    throw new IllegalArgumentException(errorstr);
                }
            }
            this.primaryAddress = new IIOPAddress(host, port);
            try {
                this.primaryAddress.configure(this.configuration);
            }
            catch (ConfigurationException ce) {
                if (!this.logger.isWarnEnabled()) break block11;
                this.logger.warn("ConfigurationException", (Throwable)ce);
            }
        }
        this.decode_extensions(protocol_identifier.toLowerCase());
    }

    private void decode_extensions(String ident) {
        this.components = new TaggedComponentList();
        if (ident.equals("ssliop")) {
            SSL ssl = new SSL();
            ssl.port = (short)this.primaryAddress.getPort();
            String propname = "jacorb.security.ssl.corbaloc_ssliop.supported_options";
            ssl.target_supports = this.get_ssl_options(propname);
            propname = "jacorb.security.ssl.corbaloc_ssliop.required_options";
            ssl.target_requires = this.get_ssl_options(propname);
            CDROutputStream out = new CDROutputStream();
            out.beginEncapsulatedArray();
            SSLHelper.write(out, ssl);
            this.components.addComponent(new TaggedComponent(20, out.getBufferCopy()));
        }
    }

    private short get_ssl_options(String propname) {
        short value = (short)this.configuration.getAttributeAsInteger(propname, 32);
        return value;
    }

    public void writeAddressProfile(CDROutputStream addressProfileStream) {
        VersionHelper.write(addressProfileStream, this.version);
        this.primaryAddress.write(addressProfileStream);
    }

    public void readAddressProfile(CDRInputStream addressProfileStream) {
        block3: {
            this.version = VersionHelper.read(addressProfileStream);
            this.primaryAddress = IIOPAddress.read(addressProfileStream);
            if (this.configuration != null) {
                try {
                    this.primaryAddress.configure(this.configuration);
                }
                catch (ConfigurationException ce) {
                    if (!this.logger.isWarnEnabled()) break block3;
                    this.logger.warn("ConfigurationException", (Throwable)ce);
                }
            }
        }
    }

    public int hash() {
        return this.hashCode();
    }

    public Object clone() throws CloneNotSupportedException {
        IIOPProfile result = (IIOPProfile)super.clone();
        result.primaryAddress = new IIOPAddress(this.primaryAddress.getHostname(), this.primaryAddress.getPort());
        result.version = new Version(this.version.major, this.version.minor);
        if (this.objectKey != null) {
            result.objectKey = new byte[this.objectKey.length];
            System.arraycopy(this.objectKey, 0, result.objectKey, 0, this.objectKey.length);
        }
        if (this.components != null) {
            result.components = (TaggedComponentList)this.components.clone();
        }
        return result;
    }

    public boolean is_match(Profile prof) {
        if (prof instanceof IIOPProfile) {
            IIOPProfile other = (IIOPProfile)prof;
            return this.primaryAddress.equals(other.primaryAddress) && ((Object)this.getAlternateAddresses()).equals(other.getAlternateAddresses()) && this.getSSLPort() == other.getSSLPort();
        }
        return false;
    }

    public int tag() {
        return 0;
    }

    public ProtocolAddressBase getAddress() {
        return this.primaryAddress;
    }

    public void patchPrimaryAddress(ProtocolAddressBase replacement) {
        if (replacement instanceof IIOPAddress) {
            this.primaryAddress.replaceFrom((IIOPAddress)replacement);
        }
    }

    public List getAlternateAddresses() {
        return this.components.getComponents(3, class$org$jacorb$orb$iiop$IIOPAddress == null ? (class$org$jacorb$orb$iiop$IIOPAddress = IIOPProfile.class$("org.jacorb.orb.iiop.IIOPAddress")) : class$org$jacorb$orb$iiop$IIOPAddress);
    }

    public SSL getSSL() {
        return (SSL)this.components.getComponent(20, class$org$omg$SSLIOP$SSLHelper == null ? (class$org$omg$SSLIOP$SSLHelper = IIOPProfile.class$("org.omg.SSLIOP.SSLHelper")) : class$org$omg$SSLIOP$SSLHelper);
    }

    public int getTLSPortFromCSIComponent() {
        CompoundSecMechList csmList = (CompoundSecMechList)this.components.getComponent(33, class$org$omg$CSIIOP$CompoundSecMechListHelper == null ? (class$org$omg$CSIIOP$CompoundSecMechListHelper = IIOPProfile.class$("org.omg.CSIIOP.CompoundSecMechListHelper")) : class$org$omg$CSIIOP$CompoundSecMechListHelper);
        if (csmList != null && csmList.mechanism_list.length > 0) {
            byte[] tlsSecTransData = csmList.mechanism_list[0].transport_mech.component_data;
            CDRInputStream in = new CDRInputStream(null, tlsSecTransData);
            try {
                int ssl_port;
                in.openEncapsulatedArray();
                TLS_SEC_TRANS tls = TLS_SEC_TRANSHelper.read(in);
                if (tls.addresses.length > 0 && (ssl_port = tls.addresses[0].port) != 0) {
                    if (ssl_port < 0) {
                        ssl_port += 65536;
                    }
                    return ssl_port;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return -1;
    }

    public int getSSLPort() {
        SSL ssl = this.getSSL();
        if (ssl == null) {
            return this.getTLSPortFromCSIComponent();
        }
        int port = ssl.port;
        if (port < 0) {
            port += 65536;
        }
        return port;
    }

    public IIOPProfile to_GIOP_1_0() {
        IIOPProfile result = new IIOPProfile(this.primaryAddress, this.objectKey);
        result.version.minor = 0;
        return result;
    }

    public boolean equals(Object other) {
        if (other instanceof Profile) {
            return this.is_match((Profile)other);
        }
        return false;
    }

    public int hashCode() {
        return this.primaryAddress.hashCode();
    }

    public String toString() {
        return this.primaryAddress.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

