/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.io.IOException;
import java.util.List;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.ORB;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.orb.giop.CodeSet;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.LocateReplyOutputStream;
import org.jacorb.orb.giop.Messages;
import org.jacorb.orb.giop.ReplyOutputStream;
import org.jacorb.orb.giop.RequestInputStream;
import org.jacorb.orb.giop.RequestListener;
import org.jacorb.poa.except.POAInternalError;
import org.jacorb.poa.except.ParentIsHolding;
import org.omg.CONV_FRAME.CodeSetContext;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.GIOP.ReplyStatusType_1_2;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.WrongAdapter;

public class ServerRequestListener
implements RequestListener,
Configurable {
    private ORB orb = null;
    private org.jacorb.poa.POA rootPOA = null;
    private org.jacorb.config.Configuration configuration = null;
    private Logger logger = null;
    private boolean require_ssl = false;

    public ServerRequestListener(org.omg.CORBA.ORB orb, POA rootPOA) {
        this.orb = (ORB)orb;
        this.rootPOA = (org.jacorb.poa.POA)rootPOA;
    }

    public void configure(Configuration myConfiguration) throws ConfigurationException {
        this.configuration = (org.jacorb.config.Configuration)myConfiguration;
        this.logger = this.configuration.getNamedLogger("jacorb.giop.server.listener");
        boolean supportSSL = this.configuration.getAttribute("jacorb.security.support_ssl", "off").equals("on");
        if (supportSSL) {
            int required = this.configuration.getAttributeAsInteger("jacorb.security.ssl.server.required_options", 16);
            this.require_ssl = supportSSL && (required & 0x60) != 0;
        }
    }

    public void requestReceived(byte[] request, GIOPConnection connection) {
        RequestInputStream in = new RequestInputStream(this.orb, request);
        if (this.require_ssl && !connection.isSSL()) {
            block19: {
                ReplyOutputStream out = new ReplyOutputStream(in.req_hdr.request_id, ReplyStatusType_1_2.SYSTEM_EXCEPTION, in.getGIOPMinor(), false, this.logger);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("About to reject request because connection is not SSL.");
                }
                SystemExceptionHelper.write(out, new NO_PERMISSION(3, CompletionStatus.COMPLETED_NO));
                try {
                    connection.sendReply(out);
                }
                catch (IOException e) {
                    if (!this.logger.isWarnEnabled()) break block19;
                    this.logger.warn("IOException", (Throwable)e);
                }
            }
            return;
        }
        if (Messages.responseExpected(in.req_hdr.response_flags)) {
            connection.incPendingMessages();
        }
        if (!connection.isTCSNegotiated()) {
            if (in.getGIOPMinor() == 0) {
                connection.markTCSNegotiated();
            } else {
                CodeSetContext ctx = CodeSet.getCodeSetContext(in.req_hdr.service_context);
                if (ctx != null) {
                    connection.setCodeSets(ctx.char_data, ctx.wchar_data);
                    connection.markTCSNegotiated();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Received CodeSetContext. Using " + CodeSet.csName(ctx.char_data) + " as TCS and " + CodeSet.csName(ctx.wchar_data) + " as TCSW");
                    }
                }
            }
        }
        in.setCodeSet(connection.getTCS(), connection.getTCSW());
        ServerRequest server_request = null;
        try {
            server_request = new ServerRequest(this.orb, in, connection);
        }
        catch (POAInternalError pie) {
            block20: {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Received a request with a non-jacorb object key");
                }
                if (in.isLocateRequest()) {
                    LocateReplyOutputStream lr_out = new LocateReplyOutputStream(in.req_hdr.request_id, 0, in.getGIOPMinor());
                    try {
                        connection.sendReply(lr_out);
                    }
                    catch (IOException e) {
                        if (this.logger.isWarnEnabled()) {
                            this.logger.warn("IOException", (Throwable)e);
                        }
                        break block20;
                    }
                }
                ReplyOutputStream out = new ReplyOutputStream(in.req_hdr.request_id, ReplyStatusType_1_2.SYSTEM_EXCEPTION, in.getGIOPMinor(), false, this.logger);
                SystemExceptionHelper.write(out, new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_NO));
                try {
                    connection.sendReply(out);
                }
                catch (IOException e) {
                    if (!this.logger.isWarnEnabled()) break block20;
                    this.logger.warn("IOException", (Throwable)e);
                }
            }
            return;
        }
        this.deliverRequest(server_request);
    }

    public void locateRequestReceived(byte[] request, GIOPConnection connection) {
        this.requestReceived(request, connection);
    }

    public void cancelRequestReceived(byte[] request, GIOPConnection connection) {
    }

    private void deliverRequest(ServerRequest request) {
        block9: {
            org.jacorb.poa.POA tmp_poa = this.rootPOA;
            try {
                String res;
                List scopes = request.getScopes();
                for (int i = 0; i < scopes.size() && !(res = (String)scopes.get(i)).equals(""); ++i) {
                    try {
                        tmp_poa = tmp_poa._getChildPOA(res);
                        continue;
                    }
                    catch (ParentIsHolding p) {
                        String[] rest_of_name = new String[scopes.size() - i];
                        for (int j = 0; j < i; ++j) {
                            rest_of_name[j] = (String)scopes.get(j + i);
                        }
                        request.setRemainingPOAName(rest_of_name);
                        break;
                    }
                }
                if (tmp_poa == null) {
                    throw new INTERNAL("Request POA null!");
                }
                tmp_poa._invoke(request);
            }
            catch (WrongAdapter wa) {
                request.setSystemException(new OBJECT_NOT_EXIST("unknown oid"));
                request.reply();
            }
            catch (SystemException one) {
                request.setSystemException(one);
                request.reply();
            }
            catch (Throwable th) {
                request.setSystemException(new UNKNOWN(th.toString()));
                request.reply();
                if (!this.logger.isWarnEnabled()) break block9;
                this.logger.warn("IOException", th);
            }
        }
    }
}

