/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.factory;

import java.lang.reflect.Constructor;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.ORB;
import org.jacorb.orb.factory.DefaultServerSocketFactory;
import org.jacorb.orb.factory.DefaultSocketFactory;
import org.jacorb.orb.factory.PortRangeSocketFactory;
import org.jacorb.orb.factory.ServerSocketFactory;
import org.jacorb.orb.factory.SocketFactory;
import org.jacorb.util.ObjectUtil;

public class SocketFactoryManager
implements Configurable {
    private static final String FACTORY_PROP = "jacorb.net.socket_factory";
    private static final String SERVER_FACTORY_PROP = "jacorb.net.server_socket_factory";
    private SocketFactory socketFactory = null;
    private ServerSocketFactory serverFactory = null;
    private ORB orb;
    private Configuration configuration = null;
    private Logger logger = null;
    private String serverFactoryClassName = null;
    private String factoryClassName = null;
    private String portNo = null;
    static /* synthetic */ Class class$org$jacorb$orb$ORB;

    public SocketFactoryManager(ORB orb) {
        this.orb = orb;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = configuration;
        this.logger = ((org.jacorb.config.Configuration)configuration).getNamedLogger("jacorb.orb.factory");
        this.serverFactoryClassName = configuration.getAttribute(SERVER_FACTORY_PROP, "");
        this.factoryClassName = configuration.getAttribute(FACTORY_PROP, "");
        this.portNo = configuration.getAttribute("jacorb.net.socket_factory.port.min", "");
    }

    public synchronized SocketFactory getSocketFactory() {
        if (this.socketFactory != null) {
            return this.socketFactory;
        }
        this.socketFactory = this.factoryClassName.length() == 0 ? (this.portNo.length() > 0 ? new PortRangeSocketFactory() : new DefaultSocketFactory()) : this.getFactory(this.factoryClassName);
        return this.socketFactory;
    }

    public synchronized ServerSocketFactory getServerSocketFactory() {
        if (this.serverFactory != null) {
            return this.serverFactory;
        }
        this.serverFactory = this.serverFactoryClassName == null || this.serverFactoryClassName.length() == 0 ? new DefaultServerSocketFactory() : this.getServerFactory(this.serverFactoryClassName);
        return this.serverFactory;
    }

    private SocketFactory getFactory(String className) {
        Object factory = this.getFactoryObject(this.orb, className);
        if (factory instanceof SocketFactory) {
            if (factory instanceof Configurable) {
                try {
                    ((Configurable)factory).configure(this.configuration);
                }
                catch (ConfigurationException ce) {
                    throw new RuntimeException("Configurable custom socket factory " + className + " could not be configured!: " + (Object)((Object)ce));
                }
            }
            return (SocketFactory)factory;
        }
        throw new RuntimeException("Custom factory " + className + " does not implement SocketFactory");
    }

    private ServerSocketFactory getServerFactory(String className) {
        Object factory = this.getFactoryObject(this.orb, className);
        if (factory instanceof ServerSocketFactory) {
            if (factory instanceof Configurable) {
                try {
                    ((Configurable)factory).configure(this.configuration);
                }
                catch (ConfigurationException ce) {
                    throw new RuntimeException("Configurable custom server socket factory " + className + " could not be configured!: " + (Object)((Object)ce));
                }
            }
            return (ServerSocketFactory)factory;
        }
        throw new RuntimeException("Custom factory " + className + " does not implement ServerSocketFactory");
    }

    private Object getFactoryObject(ORB orb, String className) {
        Object factory;
        Constructor ctor = null;
        try {
            Class sfClass = ObjectUtil.classForName(className);
            if (orb != null) {
                try {
                    ctor = sfClass.getConstructor(class$org$jacorb$orb$ORB == null ? (class$org$jacorb$orb$ORB = SocketFactoryManager.class$("org.jacorb.orb.ORB")) : class$org$jacorb$orb$ORB);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            factory = ctor != null ? ctor.newInstance(orb) : sfClass.newInstance();
        }
        catch (Exception ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(ex.getMessage());
            }
            throw new RuntimeException("Failed to create custom socket factory: " + className);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SocketFactoryManager: created " + factory.getClass().getName());
        }
        return factory;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

