/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.imr.ImRAccessImpl;
import org.jacorb.ir.RepositoryID;
import org.jacorb.orb.ClientInterceptorHandler;
import org.jacorb.orb.LocateReplyReceiver;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.Reference;
import org.jacorb.orb.ReplyReceiver;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.dii.Request;
import org.jacorb.orb.giop.ClientConnection;
import org.jacorb.orb.giop.ClientConnectionManager;
import org.jacorb.orb.giop.LocateReplyInputStream;
import org.jacorb.orb.giop.LocateRequestOutputStream;
import org.jacorb.orb.giop.ReplyInputStream;
import org.jacorb.orb.giop.ReplyPlaceholder;
import org.jacorb.orb.giop.RequestOutputStream;
import org.jacorb.orb.portableInterceptor.ClientInterceptorIterator;
import org.jacorb.orb.portableInterceptor.ClientRequestInfoImpl;
import org.jacorb.orb.util.CorbaLoc;
import org.jacorb.poa.LocalInvocationContext;
import org.jacorb.poa.POA;
import org.jacorb.poa.util.POAUtil;
import org.jacorb.util.ObjectUtil;
import org.jacorb.util.Time;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Context;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.DomainManager;
import org.omg.CORBA.ExceptionList;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.InterfaceDefHelper;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NVList;
import org.omg.CORBA.NamedValue;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyHelper;
import org.omg.CORBA.SetOverrideType;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.RemarshalException;
import org.omg.CORBA.portable.ServantObject;
import org.omg.ETF.Profile;
import org.omg.IOP.IOR;
import org.omg.Messaging.RelativeRequestTimeoutPolicy;
import org.omg.Messaging.RelativeRoundtripTimeoutPolicy;
import org.omg.Messaging.ReplyEndTimePolicy;
import org.omg.Messaging.ReplyHandler;
import org.omg.Messaging.ReplyStartTimePolicy;
import org.omg.Messaging.RequestEndTimePolicy;
import org.omg.Messaging.RequestStartTimePolicy;
import org.omg.Messaging.SyncScopePolicy;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.WrongAdapter;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantActivator;
import org.omg.PortableServer.ServantActivatorHelper;
import org.omg.PortableServer.ServantLocator;
import org.omg.PortableServer.ServantLocatorPackage.CookieHolder;
import org.omg.PortableServer.ServantManager;
import org.omg.TimeBase.UtcT;

public final class Delegate
extends org.omg.CORBA_2_3.portable.Delegate
implements Configurable {
    private ParsedIOR _pior = null;
    private IOR ior = null;
    private ClientConnection connection = null;
    private String objectReference = null;
    private ParsedIOR piorOriginal = null;
    private ParsedIOR piorLastFailed = null;
    private boolean isImR = false;
    private boolean bound = false;
    private POA poa;
    private ORB orb = null;
    private Logger logger = null;
    private boolean resolved_locality = false;
    private Set pending_replies = new HashSet();
    private Barrier pending_replies_sync = new Barrier();
    private java.lang.Object bind_sync = new java.lang.Object();
    private boolean locate_on_bind_performed = false;
    private ClientConnectionManager conn_mg = null;
    private Map policy_overrides;
    private boolean doNotCheckExceptions = false;
    private CookieHolder cookie = null;
    private String invokedOperation = null;
    private Configuration configuration = null;
    private boolean useIMR;
    private boolean locateOnBind;
    static /* synthetic */ Class class$java$lang$Object;

    private Delegate() {
    }

    public Delegate(ORB orb, ParsedIOR pior) {
        this.orb = orb;
        this._pior = pior;
        this.checkIfImR(this._pior.getTypeId());
        this.conn_mg = orb.getClientConnectionManager();
    }

    public Delegate(ORB orb, String object_reference) {
        if (object_reference.indexOf("IOR:") != 0) {
            throw new INV_OBJREF("Not an IOR: " + object_reference);
        }
        this.orb = orb;
        this.objectReference = object_reference;
        this.conn_mg = orb.getClientConnectionManager();
    }

    public Delegate(ORB orb, IOR ior) {
        this.orb = orb;
        this.ior = ior;
        this.conn_mg = orb.getClientConnectionManager();
    }

    public Delegate(ORB orb, String object_reference, boolean _donotcheckexceptions) {
        this(orb, object_reference);
        this.doNotCheckExceptions = _donotcheckexceptions;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = configuration;
        this.logger = ((org.jacorb.config.Configuration)configuration).getNamedLogger("jacorb.orb.delegate");
        this.useIMR = configuration.getAttribute("jacorb.use_imr", "off").equals("on");
        this.locateOnBind = configuration.getAttribute("jacorb.locate_on_bind", "off").equals("on");
        if (this.objectReference != null) {
            this._pior = new ParsedIOR(this.objectReference, this.orb, this.logger);
        } else if (this.ior != null) {
            this._pior = new ParsedIOR(this.ior, this.orb, this.logger);
        } else if (this._pior == null) {
            throw new ConfigurationException("Neither objectReference nor IOR set!");
        }
        this.checkIfImR(this._pior.getTypeId());
    }

    public boolean doNotCheckExceptions() {
        return this.doNotCheckExceptions;
    }

    private void checkIfImR(String typeId) {
        if (typeId.equals("IDL:org/jacorb/imr/ImplementationRepository:1.0")) {
            this.isImR = true;
        }
    }

    public int _get_TCKind() {
        return 14;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bind() {
        if (this.bound) {
            return;
        }
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            block17: {
                if (this.bound) {
                    return;
                }
                Profile p = this._pior.getEffectiveProfile();
                if (p == null) {
                    throw new COMM_FAILURE("no effective profile");
                }
                this.connection = this.conn_mg.getConnection(p);
                this.bound = true;
                if (!this.locate_on_bind_performed && this.locateOnBind) {
                    this.locate_on_bind_performed = true;
                    try {
                        LocateRequestOutputStream lros = new LocateRequestOutputStream(this._pior.get_object_key(), this.connection.getId(), this._pior.getEffectiveProfile().version().minor);
                        LocateReplyReceiver receiver = new LocateReplyReceiver(this.orb);
                        this.connection.sendRequest(lros, receiver, lros.getRequestId(), true);
                        LocateReplyInputStream lris = receiver.getReply();
                        switch (lris.rep_hdr.locate_status.value()) {
                            case 0: {
                                throw new UNKNOWN("Could not bind to object, server does not know it!");
                            }
                            case 1: {
                                break;
                            }
                            case 2: 
                            case 3: {
                                this.rebind(this.orb.object_to_string(lris.read_Object()));
                                break;
                            }
                            case 4: {
                                throw SystemExceptionHelper.read(lris);
                            }
                            case 5: {
                                throw new NO_IMPLEMENT("Server responded to LocateRequest with a status of LOC_NEEDS_ADDRESSING_MODE, but this isn't yet implemented by JacORB");
                            }
                            default: {
                                throw new RuntimeException("Unknown reply status for LOCATE_REQUEST: " + lris.rep_hdr.locate_status.value());
                            }
                        }
                    }
                    catch (SystemException se) {
                        throw se;
                    }
                    catch (Exception e) {
                        if (!this.logger.isWarnEnabled()) break block17;
                        this.logger.warn(e.getMessage());
                    }
                }
            }
            this.bind_sync.notifyAll();
        }
    }

    public void rebind(String object_reference) {
        if (object_reference.indexOf("IOR:") != 0) {
            throw new INV_OBJREF("Not an IOR: " + object_reference);
        }
        this.rebind(new ParsedIOR(object_reference, this.orb, this.logger));
    }

    public void rebind(Object o) {
        this.rebind(this.orb.object_to_string(o));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebind(ParsedIOR p) {
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            if (p.equals(this._pior)) {
                return;
            }
            if (this.piorLastFailed != null && this.piorLastFailed.equals(p)) {
                throw new TRANSIENT();
            }
            if (this.piorOriginal == null) {
                this.piorOriginal = this._pior;
            }
            this._pior = p;
            if (this.connection != null) {
                this.conn_mg.releaseConnection(this.connection);
                this.connection = null;
            }
            this.bound = false;
            this.bind();
        }
    }

    public org.omg.CORBA.Request create_request(Object self, Context ctx, String operation, NVList args, NamedValue result) {
        this.bind();
        return new Request(self, this.orb, this.connection, this.getParsedIOR().get_object_key(), operation, args, ctx, result);
    }

    public org.omg.CORBA.Request create_request(Object self, Context ctx, String operation, NVList arg_list, NamedValue result, ExceptionList exceptions, ContextList contexts) {
        throw new NO_IMPLEMENT();
    }

    public synchronized Object duplicate(Object self) {
        return self;
    }

    public boolean equals(java.lang.Object obj) {
        return obj instanceof Object && this.toString().equals(obj.toString());
    }

    public boolean equals(Object self, java.lang.Object obj) {
        return this.equals(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.connection != null) {
                this.conn_mg.releaseConnection(this.connection);
            }
            this.orb._release(this.getParsedIOR().getIORString());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Delegate gc'ed!");
            }
        }
        finally {
            super.finalize();
        }
    }

    public DomainManager[] get_domain_managers(Object self) {
        return null;
    }

    public Policy get_policy(Object self, int policy_type) {
        Policy result = this.get_client_policy(policy_type);
        if (result != null) {
            return result;
        }
        return this.get_policy(self, policy_type, this.request(self, "_get_policy", true));
    }

    public Policy get_client_policy(int policy_type) {
        Policy[] orbPolicies;
        Integer key = new Integer(policy_type);
        Policy result = null;
        if (this.policy_overrides != null) {
            result = (Policy)this.policy_overrides.get(key);
        }
        if (result == null && (orbPolicies = this.orb.getPolicyManager().get_policy_overrides(new int[]{policy_type})) != null && orbPolicies.length == 1) {
            result = orbPolicies[0];
        }
        return result;
    }

    public Policy get_policy(Object self, int policy_type, OutputStream os) {
        while (true) {
            try {
                os.write_Object(self);
                os.write_long(policy_type);
                InputStream is = this.invoke(self, os);
                return PolicyHelper.narrow(is.read_Object());
            }
            catch (RemarshalException r) {
                continue;
            }
            catch (ApplicationException _ax) {
                String _id = _ax.getId();
                throw new RuntimeException("Unexpected exception " + _id);
            }
            break;
        }
    }

    public UtcT getRequestEndTime() {
        Policy p = this.get_client_policy(28);
        if (p != null) {
            return ((RequestEndTimePolicy)p).end_time();
        }
        return null;
    }

    public UtcT getReplyEndTime() {
        Policy p = this.get_client_policy(30);
        if (p != null) {
            return ((ReplyEndTimePolicy)p).end_time();
        }
        return null;
    }

    public UtcT getRequestStartTime() {
        Policy p = this.get_client_policy(27);
        if (p != null) {
            return ((RequestStartTimePolicy)p).start_time();
        }
        return null;
    }

    public UtcT getReplyStartTime() {
        Policy p = this.get_client_policy(29);
        if (p != null) {
            return ((ReplyStartTimePolicy)p).start_time();
        }
        return null;
    }

    public long getRelativeRoundtripTimeout() {
        Policy p = this.get_client_policy(32);
        if (p != null) {
            return ((RelativeRoundtripTimeoutPolicy)p).relative_expiry();
        }
        return -1L;
    }

    public long getRelativeRequestTimeout() {
        Policy p = this.get_client_policy(31);
        if (p != null) {
            return ((RelativeRequestTimeoutPolicy)p).relative_expiry();
        }
        return -1L;
    }

    public short getSyncScope() {
        Policy p = this.get_client_policy(24);
        if (p != null) {
            return ((SyncScopePolicy)p).synchronization();
        }
        return 1;
    }

    public InterfaceDef get_interface(Object self) {
        return InterfaceDefHelper.narrow(this.get_interface_def(self));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Object get_interface_def(Object self) {
        if (this.is_really_local(self)) {
            ServantObject so = this.servant_preinvoke(self, "_interface", class$java$lang$Object == null ? (class$java$lang$Object = Delegate.class$("java.lang.Object")) : class$java$lang$Object);
            if (so == null) {
                throw new OBJ_ADAPTER("Servant from pre_invoke was null");
            }
            try {
                Servant servant = (Servant)so.servant;
                this.orb.set_delegate(servant);
                Object object = servant._get_interface_def();
                return object;
            }
            finally {
                this.servant_postinvoke(self, so);
            }
        }
        while (true) {
            try {
                OutputStream os = this.request(self, "_interface", true);
                InputStream is = this.invoke(self, os);
                return is.read_Object();
            }
            catch (RemarshalException re) {
                continue;
            }
            break;
        }
        catch (Exception ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClientConnection getConnection() {
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            this.bind();
            return this.connection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOR getIOR() {
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            if (this.piorOriginal != null) {
                return this.piorOriginal.getIOR();
            }
            return this.getParsedIOR().getIOR();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getObjectId() {
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            this.bind();
            return POAUtil.extractOID(this.getParsedIOR().get_object_key());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getObjectKey() {
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            this.bind();
            return this.getParsedIOR().get_object_key();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParsedIOR getParsedIOR() {
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            while (this._pior == null) {
                try {
                    this.bind_sync.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return this._pior;
        }
    }

    public void resolvePOA(Object self) {
        if (!this.resolved_locality) {
            this.resolved_locality = true;
            POA local_poa = this.orb.findPOA(this, self);
            if (local_poa != null) {
                this.poa = local_poa;
            }
        }
    }

    public POA getPOA() {
        return this.poa;
    }

    public ObjectImpl getReference(POA _poa) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Delegate.getReference with POA <" + (_poa != null ? _poa._getQualifiedName() : " empty") + ">");
        }
        if (_poa != null) {
            this.poa = _poa;
        }
        Reference o = new Reference(this.typeId());
        ((ObjectImpl)((java.lang.Object)o))._set_delegate(this);
        return o;
    }

    public int hash(Object self, int x) {
        return this.hashCode();
    }

    public int hashCode() {
        return this.getIDString().hashCode();
    }

    public int hashCode(Object self) {
        return this.hashCode();
    }

    public void invoke(Object self, OutputStream os, ReplyHandler replyHandler) throws ApplicationException, RemarshalException {
        this.invoke_internal(self, os, replyHandler, true);
    }

    public InputStream invoke(Object self, OutputStream os) throws ApplicationException, RemarshalException {
        return this.invoke_internal(self, os, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream invoke_internal(Object self, OutputStream os, ReplyHandler replyHandler, boolean async) throws ApplicationException, RemarshalException {
        RequestOutputStream ros = (RequestOutputStream)os;
        ReplyReceiver receiver = null;
        ClientInterceptorHandler interceptors = new ClientInterceptorHandler(this.orb, ros, self, this, this.piorOriginal, this.connection);
        interceptors.handle_send_request();
        try {
            if (!ros.response_expected()) {
                this.invoke_oneway(ros, interceptors);
                return null;
            }
            receiver = new ReplyReceiver(this, ros.operation(), ros.getReplyEndTime(), interceptors, replyHandler);
            java.lang.Object object = this.pending_replies;
            synchronized (object) {
                this.pending_replies.add(receiver);
            }
            object = this.bind_sync;
            synchronized (object) {
                if (ros.getConnection() != this.connection) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("invoke: RemarshalException");
                    }
                    throw new RemarshalException();
                }
                this.connection.sendRequest(ros, receiver, ros.requestId(), true);
            }
        }
        catch (SystemException cfe) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("invoke: SystemException");
            }
            if (!async) {
                Set set = this.pending_replies;
                synchronized (set) {
                    this.pending_replies.remove(receiver);
                }
            }
            interceptors.handle_receive_exception(cfe);
            if (cfe instanceof TRANSIENT && this.try_rebind()) {
                throw new RemarshalException();
            }
            throw cfe;
        }
        if (!async && receiver != null) {
            ReplyInputStream is = receiver.getReply();
            return is;
        }
        return null;
    }

    private void invoke_oneway(RequestOutputStream ros, ClientInterceptorHandler interceptors) throws RemarshalException, ApplicationException {
        switch (ros.syncScope()) {
            case 0: {
                this.passToTransport(ros);
                interceptors.handle_receive_other((short)0);
                break;
            }
            case 1: {
                this.connection.sendRequest(ros, false);
                interceptors.handle_receive_other((short)0);
                break;
            }
            case 2: 
            case 3: {
                ReplyReceiver rcv = new ReplyReceiver(this, ros.operation(), ros.getReplyEndTime(), interceptors, null);
                this.connection.sendRequest(ros, rcv, ros.requestId(), true);
                ReplyInputStream in = rcv.getReply();
                interceptors.handle_receive_reply(in);
                break;
            }
            default: {
                throw new MARSHAL("Illegal SYNC_SCOPE: " + ros.syncScope(), 0, CompletionStatus.COMPLETED_MAYBE);
            }
        }
    }

    private void passToTransport(final RequestOutputStream ros) {
        new Thread(new Runnable(){

            public void run() {
                Delegate.this.connection.sendRequest(ros, false);
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean try_rebind() {
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Delegate.try_rebind");
            }
            if (this.piorOriginal != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Delegate: falling back to original IOR");
                }
                this.piorLastFailed = this.getParsedIOR();
                this.rebind(this.piorOriginal);
                this.piorOriginal = null;
                this.piorLastFailed = null;
                return true;
            }
            if (this.useIMR && !this.isImR) {
                Integer orbTypeId = this.getParsedIOR().getORBTypeId();
                if (orbTypeId == null || orbTypeId != 1245790976) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Delegate: foreign IOR detected");
                    }
                    return false;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Delegate: JacORB IOR detected");
                }
                byte[] object_key = this.getParsedIOR().get_object_key();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Delegate: attempting to contact ImR");
                }
                ImRAccessImpl imr = null;
                try {
                    imr = ImRAccessImpl.connect(this.orb);
                }
                catch (Exception e) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Delegate: failed to contact ImR");
                    }
                    return false;
                }
                StringBuffer corbaloc = new StringBuffer("corbaloc:iiop:");
                corbaloc.append(imr.getImRHost());
                corbaloc.append(":");
                corbaloc.append(imr.getImRPort());
                corbaloc.append("/");
                corbaloc.append(CorbaLoc.parseKey(object_key));
                this.rebind(new ParsedIOR(corbaloc.toString(), this.orb, this.logger));
                this.piorOriginal = null;
                this.piorLastFailed = null;
                return true;
            }
            return false;
        }
    }

    public void invokeInterceptors(ClientRequestInfoImpl info, short op) throws RemarshalException {
        block3: {
            ClientInterceptorIterator intercept_iter = this.orb.getInterceptorManager().getClientIterator();
            try {
                intercept_iter.iterate(info, op);
            }
            catch (ForwardRequest fwd) {
                this.rebind(this.orb.object_to_string(fwd.forward));
                throw new RemarshalException();
            }
            catch (UserException ue) {
                if (!this.logger.isErrorEnabled()) break block3;
                this.logger.error(ue.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean is_a(Object self, String logical_type_id) {
        block17: {
            ParsedIOR pior = this.getParsedIOR();
            if (pior.getTypeId().equals(logical_type_id)) {
                return true;
            }
            String[] ids = ((ObjectImpl)self)._ids();
            for (int i = 0; i < ids.length - 1; ++i) {
                if (!ids[i].equals(logical_type_id)) continue;
                return true;
            }
            if (this.is_really_local(self)) {
                ServantObject so = this.servant_preinvoke(self, "_is_a", class$java$lang$Object == null ? (class$java$lang$Object = Delegate.class$("java.lang.Object")) : class$java$lang$Object);
                if (so == null) {
                    throw new OBJ_ADAPTER("Servant from pre_invoke was null");
                }
                try {
                    Servant servant = (Servant)so.servant;
                    this.orb.set_delegate(servant);
                    boolean bl = servant._is_a(logical_type_id);
                    return bl;
                }
                finally {
                    this.servant_postinvoke(self, so);
                }
            }
            if (!ids[0].equals("IDL:omg.org/CORBA/Object:1.0")) {
                try {
                    String classname = RepositoryID.className(ids[0], "_Stub", null);
                    int lastDot = classname.lastIndexOf(46);
                    StringBuffer scn = new StringBuffer(classname.substring(0, lastDot + 1));
                    scn.append('_');
                    scn.append(classname.substring(lastDot + 1));
                    Class stub = null;
                    try {
                        stub = ObjectUtil.classForName(scn.toString());
                    }
                    catch (ClassNotFoundException e) {
                        stub = ObjectUtil.classForName("org.omg.stub." + scn.toString());
                    }
                    Method idm = stub.getMethod("_ids", null);
                    String[] newids = (String[])idm.invoke(stub.newInstance(), (java.lang.Object[])null);
                    for (int i = 0; i < newids.length; ++i) {
                        if (!newids[i].equals(logical_type_id)) continue;
                        return true;
                    }
                }
                catch (Throwable e) {
                    if (!this.logger.isDebugEnabled()) break block17;
                    this.logger.debug("trying is_a remotely");
                }
            }
        }
        while (true) {
            try {
                OutputStream os = this.request(self, "_is_a", true);
                os.write_string(logical_type_id);
                InputStream is = this.invoke(self, os);
                return is.read_boolean();
            }
            catch (RemarshalException re) {
                continue;
            }
            break;
        }
        catch (ApplicationException ax) {
            throw new RuntimeException("Unexpected exception " + ax.getId());
        }
    }

    public boolean is_equivalent(Object self, Object obj) {
        boolean result = true;
        if (self != obj) {
            ParsedIOR pior1 = new ParsedIOR(obj.toString(), this.orb, this.logger);
            ParsedIOR pior2 = new ParsedIOR(self.toString(), this.orb, this.logger);
            result = pior2.getIDString().equals(pior1.getIDString());
        }
        return result;
    }

    public String getIDString() {
        return this.getParsedIOR().getIDString();
    }

    public boolean is_local(Object self) {
        if (this.orb.hasRequestInterceptors()) {
            return false;
        }
        return this.is_really_local(self);
    }

    private boolean is_really_local(Object self) {
        if (this.poa == null) {
            this.resolvePOA(self);
        }
        return this.poa != null;
    }

    public boolean is_nil() {
        ParsedIOR pior = this.getParsedIOR();
        return pior.getIOR().type_id.equals("") && pior.getIOR().profiles.length == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean non_existent(Object self) {
        if (this.is_really_local(self)) {
            ServantObject so = this.servant_preinvoke(self, "_non_existent", class$java$lang$Object == null ? (class$java$lang$Object = Delegate.class$("java.lang.Object")) : class$java$lang$Object);
            try {
                Servant servant = (Servant)so.servant;
                this.orb.set_delegate(servant);
                boolean bl = servant._non_existent();
                return bl;
            }
            finally {
                this.servant_postinvoke(self, so);
            }
        }
        while (true) {
            try {
                OutputStream os = this.request(self, "_non_existent", true);
                InputStream is = this.invoke(self, os);
                return is.read_boolean();
            }
            catch (RemarshalException re) {
                continue;
            }
            break;
        }
        catch (ApplicationException e) {
            throw new RuntimeException("Unexpected exception " + e.getId());
        }
    }

    public org.omg.CORBA.ORB orb(Object self) {
        return this.orb;
    }

    public synchronized void release(Object self) {
    }

    public void releaseReply(Object self, InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Time.waitFor(this.getReplyStartTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized org.omg.CORBA.Request request(Object self, String operation) {
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            this.bind();
            return new Request(self, this.orb, this.connection, this.getParsedIOR().get_object_key(), operation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized OutputStream request(Object self, String operation, boolean responseExpected) {
        UtcT requestEndTime = this.getRequestEndTime();
        long requestTimeout = this.getRelativeRequestTimeout();
        if ((requestTimeout != 0L || requestEndTime != null) && Time.hasPassed(requestEndTime = Time.earliest(Time.corbaFuture(requestTimeout), requestEndTime))) {
            throw new TIMEOUT("Request End Time exceeded prior to invocation", 0, CompletionStatus.COMPLETED_NO);
        }
        UtcT replyEndTime = this.getReplyEndTime();
        long roundtripTimeout = this.getRelativeRoundtripTimeout();
        if ((roundtripTimeout != 0L || replyEndTime != null) && Time.hasPassed(replyEndTime = Time.earliest(Time.corbaFuture(roundtripTimeout), replyEndTime))) {
            throw new TIMEOUT("Reply End Time exceeded prior to invocation", 0, CompletionStatus.COMPLETED_NO);
        }
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            this.bind();
            ParsedIOR p = this.getParsedIOR();
            RequestOutputStream ros = new RequestOutputStream(this.connection, this.connection.getId(), operation, responseExpected, this.getSyncScope(), this.getRequestStartTime(), requestEndTime, replyEndTime, p.get_object_key(), p.getEffectiveProfile().version().minor);
            if (!this.connection.isTCSNegotiated()) {
                this.connection.setCodeSet(p);
            }
            ros.setCodeSet(this.connection.getTCS(), this.connection.getTCSW());
            return ros;
        }
    }

    public void servant_postinvoke(Object self, ServantObject servant) {
        if (this.poa != null) {
            block4: {
                if (this.poa.isUseServantManager() && !this.poa.isRetain() && this.cookie != null && this.invokedOperation != null) {
                    try {
                        byte[] oid = POAUtil.extractOID(this.getParsedIOR().get_object_key());
                        ServantLocator sl = (ServantLocator)this.poa.get_servant_manager();
                        sl.postinvoke(oid, this.poa, this.invokedOperation, this.cookie.value, (Servant)servant.servant);
                        this.cookie = null;
                        this.invokedOperation = null;
                    }
                    catch (Throwable e) {
                        if (!this.logger.isWarnEnabled()) break block4;
                        this.logger.warn(e.getMessage());
                    }
                }
            }
            this.poa.removeLocalRequest();
        }
        this.orb.getPOACurrent()._removeContext(Thread.currentThread());
    }

    public ServantObject servant_preinvoke(Object self, String operation, Class expectedType) {
        if (this.poa == null) {
            this.resolvePOA(self);
        }
        if (this.poa != null) {
            ServantObject so;
            block19: {
                this.poa.addLocalRequest();
                so = new ServantObject();
                try {
                    if (this.poa.isRetain() && !this.poa.isUseServantManager() || this.poa.useDefaultServant()) {
                        try {
                            so.servant = this.poa.reference_to_servant(self);
                            break block19;
                        }
                        catch (WrongAdapter e) {
                            this.poa.removeLocalRequest();
                            throw new OBJ_ADAPTER("WrongAdapter caught when converting servant to reference. " + e);
                        }
                        catch (WrongPolicy e) {
                            this.poa.removeLocalRequest();
                            throw new OBJ_ADAPTER("WrongPolicy caught" + e);
                        }
                        catch (ObjectNotActive e) {
                            this.poa.removeLocalRequest();
                            throw new OBJECT_NOT_EXIST();
                        }
                    }
                    if (this.poa.isUseServantManager()) {
                        byte[] oid = POAUtil.extractOID(this.getParsedIOR().get_object_key());
                        ServantManager sm = this.poa.get_servant_manager();
                        if (this.poa.isRetain()) {
                            try {
                                so.servant = this.poa.id_to_servant(oid);
                            }
                            catch (ObjectNotActive ona) {
                                ServantActivator sa = (ServantActivator)sm;
                                ServantActivatorHelper.narrow(sm);
                                so.servant = sa.incarnate(oid, this.poa);
                                this.orb.set_delegate(so.servant);
                            }
                        } else {
                            ServantLocator sl = (ServantLocator)sm;
                            this.cookie = new CookieHolder();
                            this.invokedOperation = operation;
                            so.servant = sl.preinvoke(oid, this.poa, operation, this.cookie);
                        }
                        break block19;
                    }
                    throw new INTERNAL("Internal error: we should not have gotten to this piece of code!");
                }
                catch (WrongPolicy e) {
                    this.poa.removeLocalRequest();
                    throw new OBJ_ADAPTER("WrongPolicy caught" + e);
                }
                catch (org.omg.PortableServer.ForwardRequest e) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Caught forwardrequest to " + e.forward_reference + " from " + self);
                    }
                    return this.servant_preinvoke(e.forward_reference, operation, expectedType);
                }
            }
            if (!expectedType.isInstance(so.servant)) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Expected " + expectedType + " got " + so.servant.getClass());
                }
                this.poa.removeLocalRequest();
                return null;
            }
            this.orb.getPOACurrent()._addContext(Thread.currentThread(), new LocalInvocationContext(this.orb, this.poa, this.getObjectId(), (Servant)so.servant));
            return so;
        }
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("No POA! servant_preinvoke returns null");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            if (this.piorOriginal != null) {
                return this.piorOriginal.getIORString();
            }
            return this.getParsedIOR().getIORString();
        }
    }

    public String toString(Object self) {
        return this.toString();
    }

    public String typeId() {
        return this.getParsedIOR().getIOR().type_id;
    }

    public Object set_policy_override(Object self, Policy[] policies, SetOverrideType set_add) {
        if (this.policy_overrides == null) {
            this.policy_overrides = new HashMap();
        }
        if (set_add == SetOverrideType.SET_OVERRIDE) {
            this.policy_overrides.clear();
        }
        for (int i = 0; i < policies.length; ++i) {
            this.policy_overrides.put(new Integer(policies[i].policy_type()), policies[i]);
        }
        return self;
    }

    public String get_codebase(Object self) {
        return this.getParsedIOR().getCodebaseComponent();
    }

    public Set get_pending_replies() {
        return this.pending_replies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replyDone(ReplyPlaceholder placeholder) {
        Set set = this.pending_replies;
        synchronized (set) {
            this.pending_replies.remove(placeholder);
        }
    }

    public void lockBarrier() {
        this.pending_replies_sync.lockBarrier();
    }

    public void waitOnBarrier() {
        this.pending_replies_sync.waitOnBarrier();
    }

    public void openBarrier() {
        this.pending_replies_sync.openBarrier();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Barrier {
        private boolean is_open = true;

        private Barrier() {
        }

        public synchronized void waitOnBarrier() {
            while (!this.is_open) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public synchronized void lockBarrier() {
            this.is_open = false;
        }

        public synchronized void openBarrier() {
            this.is_open = true;
            this.notifyAll();
        }
    }
}

