/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.queue;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.queue.AbstractBoundedEventQueue;
import org.jacorb.notification.queue.EventQueueOverflowStrategy;
import org.jacorb.notification.queue.QueueUtil;

public class BoundedFifoEventQueue
extends AbstractBoundedEventQueue {
    private final LinkedList linkedList_ = new LinkedList();

    public BoundedFifoEventQueue(int maxSize, EventQueueOverflowStrategy overflowStrategy) {
        this(maxSize, overflowStrategy, new Object());
    }

    public BoundedFifoEventQueue(int maxSize, EventQueueOverflowStrategy overflowStrategy, Object lock) {
        super(maxSize, overflowStrategy, lock);
    }

    public String getOrderPolicyName() {
        return "FifoOrder";
    }

    public boolean isEmpty() {
        return this.linkedList_.isEmpty();
    }

    public int getSize() {
        return this.linkedList_.size();
    }

    protected Message getEarliestTimeout() {
        List _sorted = (List)this.linkedList_.clone();
        Collections.sort(_sorted, QueueUtil.ASCENDING_TIMEOUT_COMPARATOR);
        Message _event = (Message)_sorted.get(0);
        this.linkedList_.remove(_event);
        return _event;
    }

    protected Message getLeastPriority() {
        List _sorted = (List)this.linkedList_.clone();
        Collections.sort(_sorted, QueueUtil.ASCENDING_PRIORITY_COMPARATOR);
        Message _event = (Message)_sorted.get(0);
        this.linkedList_.remove(_event);
        return _event;
    }

    protected Message getNextElement() {
        return this.getOldestElement();
    }

    protected Message getOldestElement() {
        return (Message)this.linkedList_.removeFirst();
    }

    protected Message getYoungestElement() {
        return (Message)this.linkedList_.removeLast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message[] getAllElements() {
        try {
            Message[] messageArray = this.linkedList_.toArray(QueueUtil.MESSAGE_ARRAY_TEMPLATE);
            return messageArray;
        }
        finally {
            this.linkedList_.clear();
        }
    }

    protected void addElement(Message e) {
        this.linkedList_.add(e);
    }

    protected Message[] getElements(int max) {
        int _retSize = max > this.linkedList_.size() ? this.linkedList_.size() : max;
        Message[] _ret = new Message[_retSize];
        for (int x = 0; x < _retSize; ++x) {
            _ret[x] = (Message)this.linkedList_.removeFirst();
        }
        return _ret;
    }
}

