/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.queue;

import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.queue.MessageQueue;
import org.jacorb.notification.queue.MessageQueueAdapter;

public class BasicMessageQueueAdapter
implements MessageQueueAdapter {
    private final MessageQueue queue_;
    private static final Message[] EMPTY = new Message[0];

    public BasicMessageQueueAdapter(MessageQueue queue) {
        this.queue_ = queue;
    }

    public void enqeue(Message message) {
        this.queue_.put(message);
    }

    public boolean hasPendingMessages() {
        return !this.queue_.isEmpty();
    }

    public int getPendingMessagesCount() {
        return this.queue_.getSize();
    }

    public Message getMessageBlocking() throws InterruptedException {
        return this.queue_.getMessage(true);
    }

    public Message getMessageNoBlock() throws InterruptedException {
        return this.queue_.getMessage(false);
    }

    public Message[] getAllMessages() throws InterruptedException {
        return this.queue_.getAllMessages(false);
    }

    public Message[] getUpToMessages(int max) throws InterruptedException {
        return this.queue_.getMessages(max, false);
    }

    public Message[] getAtLeastMessages(int min) throws InterruptedException {
        if (this.queue_.getSize() >= min) {
            return this.queue_.getAllMessages(true);
        }
        return EMPTY;
    }

    public void clear() {
        try {
            Message[] allMessages = this.queue_.getAllMessages(false);
            for (int i = 0; i < allMessages.length; ++i) {
                Message message = allMessages[i];
                message.dispose();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String toString() {
        return this.queue_.toString();
    }

    public String getDiscardPolicyName() {
        return this.queue_.getDiscardPolicyName();
    }

    public String getOrderPolicyName() {
        return this.queue_.getOrderPolicyName();
    }

    public void addDiscardListener(MessageQueue.DiscardListener listener) {
        this.queue_.addDiscardListener(listener);
    }

    public void removeDiscardListener(MessageQueue.DiscardListener listener) {
        this.queue_.removeDiscardListener(listener);
    }
}

