/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.filter;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.filter.AbstractFilter;
import org.jacorb.notification.filter.IFilterFactoryDelegate;
import org.jacorb.notification.filter.MappingFilterImpl;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.GCDisposable;
import org.jacorb.notification.servant.ManageableServant;
import org.jacorb.notification.util.DisposableManager;
import org.jacorb.notification.util.LogUtil;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNotifyFilter.Filter;
import org.omg.CosNotifyFilter.FilterFactory;
import org.omg.CosNotifyFilter.FilterFactoryHelper;
import org.omg.CosNotifyFilter.FilterFactoryPOA;
import org.omg.CosNotifyFilter.FilterHelper;
import org.omg.CosNotifyFilter.InvalidGrammar;
import org.omg.CosNotifyFilter.MappingFilter;
import org.omg.CosNotifyFilter.MappingFilterHelper;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public class FilterFactoryImpl
extends FilterFactoryPOA
implements Disposable,
ManageableServant {
    private final ORB orb_;
    private final POA poa_;
    private final DisposableManager disposeHooks_ = new DisposableManager();
    private final List allFilters_ = new ArrayList();
    private final java.lang.Object allFiltersLock_ = new java.lang.Object();
    protected final Logger logger_;
    private FilterFactory thisFilter_;
    private final IFilterFactoryDelegate factoryDelegate_;
    private final boolean useGarbageCollector_;
    private final Configuration config_;

    public FilterFactoryImpl(ORB orb, POA poa, Configuration config, IFilterFactoryDelegate factoryDelegate) {
        this.orb_ = orb;
        this.poa_ = poa;
        this.factoryDelegate_ = factoryDelegate;
        this.config_ = config;
        this.logger_ = LogUtil.getLogger(config, this.getClass().getName());
        this.useGarbageCollector_ = config.getAttributeAsBoolean("jacorb.notification.enable_gc", false);
        if (this.useGarbageCollector_) {
            this.logger_.info("Enable Garbage Collection for Filters");
            GCThread _gcThread = new GCThread();
            this.addDisposeHook(_gcThread);
            _gcThread.start();
        }
    }

    public final void addDisposeHook(Disposable d) {
        this.disposeHooks_.addDisposable(d);
    }

    public final Filter create_filter(String grammar) throws InvalidGrammar {
        AbstractFilter _servant = this.factoryDelegate_.create_filter_servant(grammar);
        this.registerFilter(_servant);
        Filter _filter = FilterHelper.narrow(_servant.activate());
        return _filter;
    }

    public MappingFilter create_mapping_filter(String grammar, Any any) throws InvalidGrammar {
        MappingFilterImpl _mappingFilterServant = this.factoryDelegate_.create_mapping_filter_servant(this.config_, grammar, any);
        this.registerFilter(_mappingFilterServant);
        MappingFilter _filter = MappingFilterHelper.narrow(_mappingFilterServant.activate());
        return _filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void registerFilter(final GCDisposable filter) {
        if (this.useGarbageCollector_) {
            java.lang.Object object = this.allFiltersLock_;
            synchronized (object) {
                this.allFilters_.add(filter);
                filter.registerDisposable(new Disposable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void dispose() {
                        java.lang.Object object = FilterFactoryImpl.this.allFiltersLock_;
                        synchronized (object) {
                            FilterFactoryImpl.this.allFilters_.remove(filter);
                        }
                    }
                });
            }
        }
    }

    public final void deactivate() {
        try {
            this.poa_.deactivate_object(this.poa_.servant_to_id(this.getServant()));
        }
        catch (Exception e) {
            this.logger_.fatalError("cannot deactivate object", (Throwable)e);
            throw new RuntimeException();
        }
    }

    protected Servant getServant() {
        return this;
    }

    public synchronized Object activate() {
        if (this.thisFilter_ == null) {
            this.thisFilter_ = FilterFactoryHelper.narrow(this.getServant()._this_object(this.orb_));
        }
        return this.thisFilter_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        try {
            this.deactivate();
        }
        finally {
            this.disposeHooks_.dispose();
        }
    }

    public final POA _default_POA() {
        return this.poa_;
    }

    protected final ORB getORB() {
        return this.orb_;
    }

    private class GCThread
    extends Thread
    implements Disposable {
        private final AtomicBoolean active = new AtomicBoolean(true);

        public GCThread() {
            this.setName("NotificationService Filter GC");
            this.setPriority(2);
        }

        public void run() {
            while (this.active.get()) {
                try {
                    Thread.sleep(1000L);
                    this.runLoop();
                }
                catch (InterruptedException interruptedException) {}
            }
            FilterFactoryImpl.this.logger_.info("GCThread exits");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runLoop() throws InterruptedException {
            java.lang.Object object = FilterFactoryImpl.this.allFiltersLock_;
            synchronized (object) {
                Iterator i = new ArrayList(FilterFactoryImpl.this.allFilters_).iterator();
                while (i.hasNext()) {
                    GCDisposable item = (GCDisposable)i.next();
                    try {
                        item.attemptDispose();
                    }
                    catch (Exception e) {
                        i.remove();
                    }
                    this.verifyIsActive();
                }
            }
        }

        private void verifyIsActive() throws InterruptedException {
            if (!this.active.get()) {
                throw new InterruptedException();
            }
        }

        public void dispose() {
            FilterFactoryImpl.this.logger_.info("Shutdown GCThread");
            this.active.set(false);
        }
    }
}

