/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification;

import java.util.Properties;
import java.util.StringTokenizer;
import org.jacorb.notification.AbstractChannelFactory;

public class ConsoleMain {
    public static void help() {
        System.out.println("valid arguments: [-printIOR] [-printCorbaloc] [-writeIOR <filename>] [-registerName <nameId>[.<nameKind>]] [-port <oaPort>] [-channels <channels>] [-help]");
    }

    public static void addCOSNamingName(Properties props, String name) {
        int index = name.indexOf(".");
        if (name.lastIndexOf(".") != index) {
            throw new IllegalArgumentException(name + ": argument to -registerName should be " + "<nameId> or <nameId>.<nameKind>");
        }
        if (index != -1) {
            props.put("jacorb.notification.register_name.id", name.substring(0, index));
            props.put("jacorb.notification.register_name.kind", name.substring(index + 1));
        } else {
            props.put("jacorb.notification.register_name.id", name);
        }
    }

    public static AbstractChannelFactory newFactory(String[] args) throws Exception {
        Properties props = ConsoleMain.parseProperties(args);
        return AbstractChannelFactory.newFactory(props);
    }

    public static Properties parseProperties(String[] args) {
        if (args == null) {
            return new Properties();
        }
        CmdLineParser _cmdLineParser = new CmdLineParser(args);
        return _cmdLineParser.getProps();
    }

    public static String[] splitArgs(String argString) {
        if (argString == null) {
            return new String[0];
        }
        StringTokenizer tokenizer = new StringTokenizer(argString, " ");
        String[] result = new String[tokenizer.countTokens()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = tokenizer.nextToken();
        }
        return result;
    }

    public static final void main(String[] args) throws Exception {
        try {
            ConsoleMain.newFactory(args);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
            ConsoleMain.help();
        }
    }

    private static class CmdLineParser {
        private Properties props = new Properties();

        public Properties getProps() {
            return this.props;
        }

        public CmdLineParser(String[] args) {
            this.perform(args);
        }

        private void perform(String[] args) throws IllegalArgumentException {
            try {
                for (int i = 0; i < args.length; ++i) {
                    if (args[i].equals("-printIOR")) {
                        this.props.put("jacorb.notification.print_ior", "on");
                        continue;
                    }
                    if (args[i].equals("-printCorbaloc")) {
                        this.props.put("jacorb.notification.print_corbaloc", "on");
                        continue;
                    }
                    if (args[i].equals("-help")) {
                        throw new IllegalArgumentException("usage");
                    }
                    if (args[i].equals("-port")) {
                        this.props.put("OAPort", args[++i]);
                        continue;
                    }
                    if (args[i].equals("-channels")) {
                        this.props.put("jacorb.notification.start_channels", args[++i]);
                        continue;
                    }
                    if (args[i].equals("-writeIOR")) {
                        this.props.put("jacorb.notification.ior_file", args[++i]);
                        continue;
                    }
                    if (args[i].equals("-registerName")) {
                        String name = args[++i];
                        ConsoleMain.addCOSNamingName(this.props, name);
                        continue;
                    }
                    if (args[i].equals("-typed")) {
                        this.props.put("jacorb.notification.enable_typed_channel", "on");
                        continue;
                    }
                    throw new IllegalArgumentException("unknown Argument: " + args[i]);
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("illegal number of arguments");
            }
        }
    }
}

