/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.IContainer;
import org.jacorb.notification.IFactory;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.FilterStage;
import org.jacorb.notification.interfaces.FilterStageSource;
import org.jacorb.notification.interfaces.JMXManageable;
import org.jacorb.notification.interfaces.ProxyEvent;
import org.jacorb.notification.interfaces.ProxyEventListener;
import org.jacorb.notification.servant.AbstractAdmin;
import org.jacorb.notification.servant.AbstractSupplierAdmin;
import org.jacorb.notification.servant.FilterStageListManager;
import org.jacorb.notification.servant.ManageableServant;
import org.jacorb.notification.util.AdminPropertySet;
import org.jacorb.notification.util.DisposableManager;
import org.jacorb.notification.util.PropertySet;
import org.jacorb.notification.util.QoSPropertySet;
import org.omg.CORBA.Any;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CosNotification.NamedPropertyRangeSeqHolder;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.UnsupportedAdmin;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.AdminLimit;
import org.omg.CosNotifyChannelAdmin.AdminLimitExceeded;
import org.omg.CosNotifyChannelAdmin.AdminNotFound;
import org.omg.CosNotifyChannelAdmin.InterFilterGroupOperator;
import org.omg.CosNotifyFilter.FilterFactory;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;
import org.picocontainer.MutablePicoContainer;

public abstract class AbstractEventChannel
implements ManageableServant,
JMXManageable {
    private static final Integer DEFAULT_ADMIN_KEY = new Integer(0);
    private final DisposableManager disposables_ = new DisposableManager();
    protected final Logger logger_;
    protected final ORB orb_;
    private final POA poa_;
    private final Configuration configuration_;
    private final AtomicInteger maxNumberOfSuppliers_ = new AtomicInteger(0);
    private final AtomicInteger maxNumberOfConsumers_ = new AtomicInteger(0);
    private final AdminPropertySet adminSettings_;
    private final QoSPropertySet qosSettings_;
    private final FilterStageListManager listManager_;
    private final FilterFactory defaultFilterFactory_;
    private final Object modifyConsumerAdminsLock_ = new Object();
    private final Object modifySupplierAdminsLock_ = new Object();
    private final Map consumerAdminServants_ = new HashMap();
    private final Map supplierAdminServants_ = new HashMap();
    private final AtomicInteger adminIdPool_ = new AtomicInteger(1);
    private final AtomicInteger numberOfConsumers_ = new AtomicInteger(0);
    private final AtomicInteger numberOfSuppliers_ = new AtomicInteger(0);
    private final ProxyEventListener proxyConsumerEventListener_ = new ProxyEventListener(){

        public void actionProxyCreationRequest(ProxyEvent event) throws AdminLimitExceeded {
            AbstractEventChannel.this.addConsumer();
        }

        public void actionProxyCreated(ProxyEvent event) {
        }

        public void actionProxyDisposed(ProxyEvent event) {
            AbstractEventChannel.this.removeConsumer();
        }
    };
    private final ProxyEventListener proxySupplierEventListener_ = new ProxyEventListener(){

        public void actionProxyCreationRequest(ProxyEvent event) throws AdminLimitExceeded {
            AbstractEventChannel.this.addSupplier();
        }

        public void actionProxyCreated(ProxyEvent event) {
        }

        public void actionProxyDisposed(ProxyEvent event) {
            AbstractEventChannel.this.removeSupplier();
        }
    };
    protected final MutablePicoContainer container_;
    private final int id_;
    private final AtomicBoolean destroyed_ = new AtomicBoolean(false);
    protected JMXManageable.JMXCallback jmxCallback_;
    static /* synthetic */ Class class$org$jacorb$notification$SubscriptionManager;
    static /* synthetic */ Class class$org$jacorb$notification$OfferManager;
    static /* synthetic */ Class class$org$jacorb$notification$IContainer;

    public AbstractEventChannel(IFactory factory, ORB orb, POA poa, Configuration config, FilterFactory filterFactory) {
        this.id_ = factory.getChannelID();
        this.orb_ = orb;
        this.poa_ = poa;
        this.configuration_ = config;
        this.defaultFilterFactory_ = filterFactory;
        this.container_ = factory.getContainer();
        this.logger_ = ((org.jacorb.config.Configuration)config).getNamedLogger(this.getClass().getName());
        this.container_.registerComponentImplementation(class$org$jacorb$notification$SubscriptionManager == null ? (class$org$jacorb$notification$SubscriptionManager = AbstractEventChannel.class$("org.jacorb.notification.SubscriptionManager")) : class$org$jacorb$notification$SubscriptionManager);
        this.container_.registerComponentImplementation(class$org$jacorb$notification$OfferManager == null ? (class$org$jacorb$notification$OfferManager = AbstractEventChannel.class$("org.jacorb.notification.OfferManager")) : class$org$jacorb$notification$OfferManager);
        this.adminSettings_ = new AdminPropertySet(this.configuration_);
        this.qosSettings_ = new QoSPropertySet(this.configuration_, 0);
        this.listManager_ = new FilterStageListManager(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void fetchListData(FilterStageListManager.FilterStageList list) {
                Object object = AbstractEventChannel.this.modifyConsumerAdminsLock_;
                synchronized (object) {
                    Iterator i = AbstractEventChannel.this.consumerAdminServants_.keySet().iterator();
                    while (i.hasNext()) {
                        Integer _key = (Integer)i.next();
                        list.add((FilterStage)AbstractEventChannel.this.consumerAdminServants_.get(_key));
                    }
                }
            }
        };
    }

    private void addConsumer() throws AdminLimitExceeded {
        int _maxNumberOfConsumers = this.maxNumberOfConsumers_.get();
        int _numberOfConsumers = this.numberOfConsumers_.incrementAndGet();
        if (_maxNumberOfConsumers != 0 && _numberOfConsumers > _maxNumberOfConsumers) {
            this.numberOfConsumers_.decrementAndGet();
            Any _any = this.orb_.create_any();
            _any.insert_long(_maxNumberOfConsumers);
            AdminLimit _limit = new AdminLimit("consumer limit", _any);
            throw new AdminLimitExceeded("Consumer creation request exceeds AdminLimit.", _limit);
        }
    }

    private void removeConsumer() {
        this.numberOfConsumers_.decrementAndGet();
    }

    private void addSupplier() throws AdminLimitExceeded {
        int _numberOfSuppliers = this.numberOfSuppliers_.incrementAndGet();
        int _maxNumberOfSuppliers = this.maxNumberOfSuppliers_.get();
        if (_maxNumberOfSuppliers != 0 && _numberOfSuppliers > _maxNumberOfSuppliers) {
            this.numberOfSuppliers_.decrementAndGet();
            Any _any = this.orb_.create_any();
            _any.insert_long(_maxNumberOfSuppliers);
            AdminLimit _limit = new AdminLimit("supplier limit", _any);
            throw new AdminLimitExceeded("supplier creation request exceeds AdminLimit.", _limit);
        }
    }

    private void removeSupplier() {
        this.numberOfSuppliers_.decrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isDefaultConsumerAdminActive() {
        Object object = this.modifyConsumerAdminsLock_;
        synchronized (object) {
            return this.consumerAdminServants_.containsKey(DEFAULT_ADMIN_KEY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isDefaultSupplierAdminActive() {
        Object object = this.modifySupplierAdminsLock_;
        synchronized (object) {
            return this.supplierAdminServants_.containsKey(DEFAULT_ADMIN_KEY);
        }
    }

    public final FilterFactory default_filter_factory() {
        return this.defaultFilterFactory_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int[] get_all_consumeradmins() {
        Object object = this.modifyConsumerAdminsLock_;
        synchronized (object) {
            int[] _allConsumerAdminKeys = new int[this.consumerAdminServants_.size()];
            Iterator i = this.consumerAdminServants_.keySet().iterator();
            int x = 0;
            while (i.hasNext()) {
                _allConsumerAdminKeys[x] = (Integer)i.next();
                ++x;
            }
            return _allConsumerAdminKeys;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int[] get_all_supplieradmins() {
        Object object = this.modifySupplierAdminsLock_;
        synchronized (object) {
            int[] _allSupplierAdminKeys = new int[this.supplierAdminServants_.size()];
            Iterator i = this.supplierAdminServants_.keySet().iterator();
            int x = 0;
            while (i.hasNext()) {
                _allSupplierAdminKeys[x] = (Integer)i.next();
                ++x;
            }
            return _allSupplierAdminKeys;
        }
    }

    public final Property[] get_admin() {
        return this.adminSettings_.toArray();
    }

    public final Property[] get_qos() {
        return this.qosSettings_.toArray();
    }

    public final void set_qos(Property[] props) throws UnsupportedQoS {
        this.qosSettings_.validate_qos(props, new NamedPropertyRangeSeqHolder());
        this.qosSettings_.set_qos(props);
        this.logger_.debug("set QoS: " + this.qosSettings_);
    }

    public final void validate_qos(Property[] props, NamedPropertyRangeSeqHolder namedPropertySeqHolder) throws UnsupportedQoS {
        this.qosSettings_.validate_qos(props, namedPropertySeqHolder);
    }

    public final void set_admin(Property[] adminProps) throws UnsupportedAdmin {
        this.adminSettings_.validate_admin(adminProps);
        this.adminSettings_.set_admin(adminProps);
        this.configureAdminLimits(this.adminSettings_);
    }

    private void configureAdminLimits(PropertySet adminProperties) {
        Any _maxConsumers = adminProperties.get("MaxConsumers");
        this.setMaxNumberOfConsumers(_maxConsumers.extract_long());
        Any _maxSuppliers = adminProperties.get("MaxSuppliers");
        this.setMaxNumberOfSuppliers(_maxSuppliers.extract_long());
    }

    public final void destroy() {
        if (this.destroyed_.compareAndSet(false, true)) {
            this.container_.dispose();
            List list = this.container_.getComponentInstancesOfType(class$org$jacorb$notification$IContainer == null ? (class$org$jacorb$notification$IContainer = AbstractEventChannel.class$("org.jacorb.notification.IContainer")) : class$org$jacorb$notification$IContainer);
            Iterator i = list.iterator();
            while (i.hasNext()) {
                IContainer element = (IContainer)i.next();
                element.destroy();
            }
        } else {
            throw new OBJECT_NOT_EXIST();
        }
    }

    public final void dispose() {
        if (this.logger_.isInfoEnabled()) {
            this.logger_.info("destroy channel " + this.id_);
        }
        this.deactivate();
        this.disposables_.dispose();
    }

    public final POA _default_POA() {
        return this.poa_;
    }

    public boolean isPersistent() {
        return false;
    }

    public final int getNumberOfConnectedClients() {
        return this.numberOfConsumers_.get() + this.numberOfSuppliers_.get();
    }

    public final int getMaxNumberOfSuppliers() {
        return this.maxNumberOfSuppliers_.get();
    }

    public void setMaxNumberOfSuppliers(int max) {
        if (max < 0) {
            throw new IllegalArgumentException();
        }
        this.maxNumberOfSuppliers_.set(max);
        if (this.logger_.isInfoEnabled()) {
            this.logger_.info("set MaxNumberOfSuppliers=" + this.maxNumberOfSuppliers_);
        }
    }

    public final int getMaxNumberOfConsumers() {
        return this.maxNumberOfConsumers_.get();
    }

    public void setMaxNumberOfConsumers(int max) {
        if (max < 0) {
            throw new IllegalArgumentException();
        }
        this.maxNumberOfConsumers_.set(max);
        if (this.logger_.isInfoEnabled()) {
            this.logger_.info("set MaxNumberOfConsumers=" + this.maxNumberOfConsumers_);
        }
    }

    public final void deactivate() {
        try {
            this.poa_.deactivate_object(this.poa_.servant_to_id(this.getServant()));
        }
        catch (Exception e) {
            this.logger_.error("Unable to deactivate EventChannel Object", (Throwable)e);
            throw new RuntimeException();
        }
    }

    protected abstract Servant getServant();

    private Property[] createQoSPropertiesForAdmin() {
        HashMap _copy = new HashMap(this.qosSettings_.toMap());
        _copy.remove("EventReliability");
        return PropertySet.map2Props(_copy);
    }

    protected AbstractAdmin get_consumeradmin_internal(int identifier) throws AdminNotFound {
        Object object = this.modifyConsumerAdminsLock_;
        synchronized (object) {
            Integer _key = new Integer(identifier);
            if (this.consumerAdminServants_.containsKey(_key)) {
                return (AbstractAdmin)this.consumerAdminServants_.get(_key);
            }
            throw new AdminNotFound("ID " + identifier + " does not exist.");
        }
    }

    protected AbstractAdmin get_supplieradmin_internal(int identifier) throws AdminNotFound {
        Object object = this.modifySupplierAdminsLock_;
        synchronized (object) {
            Integer _key = new Integer(identifier);
            if (this.supplierAdminServants_.containsKey(_key)) {
                return (AbstractAdmin)this.supplierAdminServants_.get(_key);
            }
            throw new AdminNotFound("ID " + identifier + " does not exist.");
        }
    }

    List getAllConsumerAdmins() {
        return this.listManager_.getList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractAdmin getDefaultConsumerAdminServant() {
        AbstractAdmin _admin;
        Object object = this.modifyConsumerAdminsLock_;
        synchronized (object) {
            _admin = (AbstractAdmin)this.consumerAdminServants_.get(DEFAULT_ADMIN_KEY);
            if (_admin == null) {
                _admin = this.newConsumerAdminServant(DEFAULT_ADMIN_KEY);
                _admin.setInterFilterGroupOperator(InterFilterGroupOperator.AND_OP);
                try {
                    _admin.set_qos(this.createQoSPropertiesForAdmin());
                }
                catch (UnsupportedQoS e) {
                    this.logger_.error("unable to set qos", (Throwable)e);
                }
                this.addToConsumerAdmins(_admin);
            }
        }
        return _admin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToConsumerAdmins(AbstractAdmin admin) {
        final Integer _key = admin.getID();
        admin.registerDisposable(new Disposable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dispose() {
                Object object = AbstractEventChannel.this.modifyConsumerAdminsLock_;
                synchronized (object) {
                    AbstractEventChannel.this.consumerAdminServants_.remove(_key);
                    AbstractEventChannel.this.listManager_.actionSourceModified();
                }
            }
        });
        Object object = this.modifyConsumerAdminsLock_;
        synchronized (object) {
            this.consumerAdminServants_.put(_key, admin);
            this.listManager_.actionSourceModified();
        }
    }

    protected AbstractAdmin new_for_consumers_servant(InterFilterGroupOperator filterGroupOperator, IntHolder intHolder) {
        AbstractAdmin _admin = this.newConsumerAdminServant(this.createAdminID());
        intHolder.value = _admin.getID();
        _admin.setInterFilterGroupOperator(filterGroupOperator);
        try {
            _admin.set_qos(this.createQoSPropertiesForAdmin());
        }
        catch (UnsupportedQoS e) {
            this.logger_.error("unable to set QoS", (Throwable)e);
        }
        _admin.addProxyEventListener(this.proxySupplierEventListener_);
        this.addToConsumerAdmins(_admin);
        return _admin;
    }

    private int createAdminID() {
        return this.adminIdPool_.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToSupplierAdmins(AbstractAdmin admin) {
        final Integer _key = admin.getID();
        admin.registerDisposable(new Disposable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dispose() {
                Object object = AbstractEventChannel.this.modifySupplierAdminsLock_;
                synchronized (object) {
                    AbstractEventChannel.this.supplierAdminServants_.remove(_key);
                }
            }
        });
        Object object = this.modifySupplierAdminsLock_;
        synchronized (object) {
            this.supplierAdminServants_.put(_key, admin);
        }
    }

    protected AbstractAdmin new_for_suppliers_servant(InterFilterGroupOperator filterGroupOperator, IntHolder intHolder) {
        AbstractAdmin _admin = this.newSupplierAdminServant(this.createAdminID());
        intHolder.value = _admin.getID();
        _admin.setInterFilterGroupOperator(filterGroupOperator);
        try {
            _admin.set_qos(this.createQoSPropertiesForAdmin());
        }
        catch (UnsupportedQoS e) {
            this.logger_.error("unable to set QoS", (Throwable)e);
        }
        _admin.addProxyEventListener(this.proxyConsumerEventListener_);
        this.addToSupplierAdmins(_admin);
        return _admin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractAdmin getDefaultSupplierAdminServant() {
        AbstractAdmin _admin;
        Object object = this.modifySupplierAdminsLock_;
        synchronized (object) {
            _admin = (AbstractAdmin)this.supplierAdminServants_.get(DEFAULT_ADMIN_KEY);
            if (_admin == null) {
                _admin = this.newSupplierAdminServant(DEFAULT_ADMIN_KEY);
                _admin.setInterFilterGroupOperator(InterFilterGroupOperator.AND_OP);
                try {
                    _admin.set_qos(this.createQoSPropertiesForAdmin());
                }
                catch (UnsupportedQoS e) {
                    this.logger_.error("unable to set qos", (Throwable)e);
                }
                this.addToSupplierAdmins(_admin);
            }
        }
        return _admin;
    }

    private AbstractAdmin newConsumerAdminServant(int id) {
        return this.newConsumerAdmin(id);
    }

    protected abstract AbstractAdmin newConsumerAdmin(int var1);

    private AbstractAdmin newSupplierAdminServant(int id) {
        AbstractSupplierAdmin _admin = this.newSupplierAdmin(id);
        _admin.setSubsequentFilterStageSource(new FilterStageSourceAdapter(this));
        return _admin;
    }

    protected abstract AbstractSupplierAdmin newSupplierAdmin(int var1);

    public int getID() {
        return this.id_;
    }

    public final void registerDisposable(Disposable d) {
        this.disposables_.addDisposable(d);
    }

    public final String getJMXObjectName() {
        return "channel=" + this.getMBeanName();
    }

    public final String getMBeanName() {
        return this.getMBeanType() + "-" + this.getID();
    }

    protected abstract String getMBeanType();

    public String[] getJMXNotificationTypes() {
        return new String[0];
    }

    public void setJMXCallback(JMXManageable.JMXCallback callback) {
        this.jmxCallback_ = callback;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class FilterStageSourceAdapter
    implements FilterStageSource {
        final WeakReference channelRef_;

        FilterStageSourceAdapter(AbstractEventChannel channel) {
            this.channelRef_ = new WeakReference<AbstractEventChannel>(channel);
        }

        public List getSubsequentFilterStages() {
            return ((AbstractEventChannel)this.channelRef_.get()).getAllConsumerAdmins();
        }
    }
}

