/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.ir;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.ir.Container;
import org.jacorb.ir.IRObject;
import org.jacorb.ir.PrimitiveDef;
import org.omg.CORBA.AliasDef;
import org.omg.CORBA.Any;
import org.omg.CORBA.ArrayDef;
import org.omg.CORBA.ConstantDef;
import org.omg.CORBA.Contained;
import org.omg.CORBA.ContainerPackage.Description;
import org.omg.CORBA.DefinitionKind;
import org.omg.CORBA.EnumDef;
import org.omg.CORBA.ExceptionDef;
import org.omg.CORBA.FixedDef;
import org.omg.CORBA.IDLType;
import org.omg.CORBA.Initializer;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.ModuleDef;
import org.omg.CORBA.NativeDef;
import org.omg.CORBA.ORB;
import org.omg.CORBA.PrimitiveDefHelper;
import org.omg.CORBA.PrimitiveDefPOATie;
import org.omg.CORBA.PrimitiveKind;
import org.omg.CORBA.Repository;
import org.omg.CORBA.RepositoryHelper;
import org.omg.CORBA.RepositoryOperations;
import org.omg.CORBA.RepositoryPOATie;
import org.omg.CORBA.SequenceDef;
import org.omg.CORBA.StringDef;
import org.omg.CORBA.StructDef;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.UnionDef;
import org.omg.CORBA.UnionMember;
import org.omg.CORBA.ValueBoxDef;
import org.omg.CORBA.ValueDef;
import org.omg.CORBA.WstringDef;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;

public class RepositoryImpl
extends IRObject
implements RepositoryOperations,
Configurable {
    private String classpath;
    private Hashtable contained = new Hashtable();
    private Container[] containers;
    private Container delegate;
    private POA poa;
    private ClassLoader loader;
    public static char fileSeparator = System.getProperty("file.separator").charAt(0);
    public static String pathSeparator = System.getProperty("path.separator");
    private org.jacorb.config.Configuration configuration = null;
    private Logger logger = null;

    public RepositoryImpl(String classpath, String outfile, URLClassLoader loader) throws Exception {
        this.classpath = classpath;
        this.loader = loader;
        this.def_kind = DefinitionKind.dk_Repository;
        this.name = "Repository";
        StringTokenizer strtok = new StringTokenizer(classpath, File.pathSeparator);
        String[] paths = new String[strtok.countTokens()];
        this.containers = new Container[paths.length];
        ORB orb = ORB.init(new String[0], null);
        this.configure(((org.jacorb.orb.ORB)orb).getConfiguration());
        this.poa = POAHelper.narrow(orb.resolve_initial_references("RootPOA"));
        Repository myRef = RepositoryHelper.narrow(this.poa.servant_to_reference(new RepositoryPOATie(this)));
        int i = 0;
        while (strtok.hasMoreTokens()) {
            paths[i] = strtok.nextToken();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("found path: " + paths[i]);
            }
            this.containers[i] = new Container(this, paths[i], null, loader, this.poa, this.logger);
            ++i;
        }
        this.delegate = this.containers[0];
        PrintWriter out = new PrintWriter(new FileOutputStream(outfile), true);
        out.println(orb.object_to_string(myRef));
        this.setReference(myRef);
        out.close();
        this.poa.the_POAManager().activate();
        if (this.logger.isInfoEnabled()) {
            URL[] urls = loader.getURLs();
            StringBuffer sb = new StringBuffer("IR configured for class path: ");
            for (int i2 = 0; i2 < urls.length; ++i2) {
                sb.append(urls[i2].toString() + "\n");
            }
            this.logger.info(sb.toString());
        }
    }

    public void configure(Configuration myConfiguration) throws ConfigurationException {
        this.configuration = (org.jacorb.config.Configuration)myConfiguration;
        this.logger = this.configuration.getNamedLogger("jacorb.ir");
    }

    private String idToScopedName(String id) {
        String scoped = "";
        if (!id.startsWith("IDL:") || !id.endsWith(":1.0")) {
            return null;
        }
        String base = id.substring(id.indexOf(58) + 1, id.lastIndexOf(58)).replace(fileSeparator, '/');
        if (base.startsWith("omg.org")) {
            base = "org/omg" + base.substring(7);
        }
        StringTokenizer strtok = new StringTokenizer(base, "/");
        int i = 0;
        while (strtok.hasMoreTokens()) {
            scoped = scoped + "::" + strtok.nextToken();
            ++i;
        }
        return scoped;
    }

    public Contained lookup_id(String search_id) {
        String name;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("IR lookup_id: " + search_id);
        }
        if ((name = this.idToScopedName(search_id)) == null) {
            return null;
        }
        return this.lookup(name);
    }

    public org.omg.CORBA.PrimitiveDef get_primitive(PrimitiveKind kind) {
        try {
            return PrimitiveDefHelper.narrow(this.poa.servant_to_reference(new PrimitiveDefPOATie(new PrimitiveDef(kind.value()))));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public StringDef create_string(int bound) {
        return null;
    }

    public WstringDef create_wstring(int bound) {
        return null;
    }

    public FixedDef create_fixed(short digits, short scale) {
        return null;
    }

    public SequenceDef create_sequence(int bound, IDLType element_type) {
        return null;
    }

    public ArrayDef create_array(int length, IDLType element_type) {
        return null;
    }

    public TypeCode get_canonical_typecode(TypeCode tc) {
        return null;
    }

    public Contained lookup(String name) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("IR lookup : " + name);
        }
        Contained result = null;
        for (int i = 0; i < this.containers.length && (result = this.containers[i].lookup(name)) == null; ++i) {
        }
        return result;
    }

    public Contained[] lookup_name(String search_name, int levels_to_search, DefinitionKind limit_type, boolean exclude_inherited) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("IR lookup_name: " + search_name);
        }
        Contained[] result = null;
        Vector<Contained[]> intermediate = new Vector<Contained[]>();
        for (int i = 0; i < this.containers.length; ++i) {
            intermediate.addElement(this.containers[i].lookup_name(search_name, levels_to_search, limit_type, exclude_inherited));
        }
        int size = 0;
        for (int i = 0; i < intermediate.size(); ++i) {
            size += ((Object[])intermediate.elementAt(i)).length;
        }
        result = new Contained[size];
        int start = 0;
        for (int i = 0; i < intermediate.size(); ++i) {
            Contained[] src = (Contained[])intermediate.elementAt(i);
            System.arraycopy(src, 0, result, start, src.length);
            start += src.length;
        }
        return result;
    }

    public Contained[] contents(DefinitionKind limit_type, boolean exclude_inherited) {
        Contained[] result = null;
        Vector<Contained[]> intermediate = new Vector<Contained[]>();
        for (int i = 0; i < this.containers.length; ++i) {
            intermediate.addElement(this.containers[i].contents(limit_type, exclude_inherited));
        }
        int size = 0;
        for (int i = 0; i < intermediate.size(); ++i) {
            size += ((Object[])intermediate.elementAt(i)).length;
        }
        result = new Contained[size];
        int start = 0;
        for (int i = 0; i < intermediate.size(); ++i) {
            Contained[] src = (Contained[])intermediate.elementAt(i);
            System.arraycopy(src, 0, result, start, src.length);
            start += src.length;
        }
        return result;
    }

    public Description[] describe_contents(DefinitionKind limit_type, boolean exclude_inherited, int max_returned_objs) {
        Contained[] c = this.contents(limit_type, exclude_inherited);
        int size = max_returned_objs > c.length ? max_returned_objs : c.length;
        Description[] result = new Description[size];
        for (int i = 0; i < size; ++i) {
            result[i] = new Description();
            org.omg.CORBA.ContainedPackage.Description cd_descr = c[i].describe();
            result[i].contained_object = c[i];
            result[i].kind = cd_descr.kind;
            result[i].value = cd_descr.value;
        }
        return result;
    }

    void define() {
    }

    public void loadContents() {
        int i;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Repository loads contents...");
        }
        for (i = 0; i < this.containers.length; ++i) {
            this.containers[i].loadContents();
        }
        for (i = 0; i < this.containers.length; ++i) {
            this.containers[i].define();
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Repository contents loaded");
        }
    }

    public ModuleDef create_module(String id, String name, String version) {
        return this.delegate.create_module(id, name, version);
    }

    public ConstantDef create_constant(String id, String name, String version, IDLType type, Any value) {
        return this.delegate.create_constant(id, name, version, type, value);
    }

    public StructDef create_struct(String id, String name, String version, StructMember[] members) {
        return this.delegate.create_struct(id, name, version, members);
    }

    public UnionDef create_union(String id, String name, String version, IDLType discriminator_type, UnionMember[] members) {
        return this.delegate.create_union(id, name, version, discriminator_type, members);
    }

    public EnumDef create_enum(String id, String name, String version, String[] members) {
        return this.delegate.create_enum(id, name, version, members);
    }

    public AliasDef create_alias(String id, String name, String version, IDLType original_type) {
        return this.delegate.create_alias(id, name, version, original_type);
    }

    public ExceptionDef create_exception(String id, String name, String version, StructMember[] member) {
        return this.delegate.create_exception(id, name, version, member);
    }

    public InterfaceDef create_interface(String id, String name, String version, InterfaceDef[] base_interfaces, boolean is_abstract) {
        return this.delegate.create_interface(id, name, version, base_interfaces, is_abstract);
    }

    public ValueBoxDef create_value_box(String id, String name, String version, IDLType type) {
        return this.delegate.create_value_box(id, name, version, type);
    }

    public ValueDef create_value(String id, String name, String version, boolean is_custom, boolean is_abstract, ValueDef base_value, boolean is_truncatable, ValueDef[] abstract_base_values, InterfaceDef[] supported_interfaces, Initializer[] initializers) {
        return this.delegate.create_value(id, name, version, is_custom, is_abstract, base_value, is_truncatable, abstract_base_values, supported_interfaces, initializers);
    }

    public NativeDef create_native(String id, String name, String version) {
        return this.delegate.create_native(id, name, version);
    }

    public void destroy() {
        this.delegate.destroy();
    }
}

