/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.config;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.config.Configuration;
import org.jacorb.config.LoggerFactory;
import org.jacorb.orb.ORB;
import org.jacorb.util.ObjectUtil;

public class JacORBConfiguration
extends DefaultConfiguration
implements Configuration {
    private static final String fileSuffix = ".properties";
    private static final String COMMON_PROPS = "orb.properties";
    private static final String TRUE = "true";
    private static final String ON = "on";
    private static final String EMPTY_STR = "";
    private static final int DEFAULT_LOG_LEVEL = 0;
    private ORB orb = null;
    private Logger logger = null;
    private LoggerFactory loggerFactory = null;
    private final String loggerFactoryClzName = "org.jacorb.config.LogKitLoggerFactory";

    public static Configuration getConfiguration(Properties props, ORB orb, boolean isApplet) throws ConfigurationException {
        String tmp;
        String myOrbID;
        String orbID = "jacorb";
        String string = myOrbID = isApplet ? null : System.getProperty("ORBid");
        if (props != null && (tmp = (String)props.get("ORBid")) != null) {
            myOrbID = tmp;
        }
        if (myOrbID != null) {
            if (myOrbID.equals("orb") || myOrbID.equals("jacorb")) {
                throw new ConfigurationException("Illegal orbID, <" + myOrbID + "> is reserved");
            }
            orbID = myOrbID;
        }
        return new JacORBConfiguration(orbID, props, orb, isApplet);
    }

    private JacORBConfiguration(String name, Properties orbProperties, ORB orb, boolean isApplet) throws ConfigurationException {
        super(name);
        this.orb = orb;
        if (isApplet) {
            this.initApplet(name, orbProperties);
        } else {
            this.init(name, orbProperties);
        }
        this.initLogging();
    }

    private void init(String name, Properties orbProperties) throws ConfigurationException {
        List customPropFileNames;
        String configDir;
        if (name == null) {
            throw new ConfigurationException("Illegal null value for ORB name!");
        }
        String separator = System.getProperty("file.separator");
        String home = System.getProperty("user.home");
        String lib = System.getProperty("java.home");
        boolean loaded = false;
        this.setAttributes(System.getProperties());
        int logLevel = this.getAttributeAsInteger("jacorb.config.log.verbosity", 0);
        Properties commonProps = JacORBConfiguration.loadPropertiesFromFile(lib + separator + "lib" + separator + COMMON_PROPS);
        if (commonProps != null) {
            this.setAttributes(commonProps);
            logLevel = this.getAttributeAsInteger("jacorb.config.log.verbosity", 0);
            loaded = true;
            if (logLevel > 2) {
                System.out.println("[ base configuration loaded from file " + lib + separator + "lib" + separator + COMMON_PROPS + " ]");
            }
        }
        if ((commonProps = JacORBConfiguration.loadPropertiesFromFile(home + separator + COMMON_PROPS)) != null) {
            this.setAttributes(commonProps);
            loaded = true;
            logLevel = this.getAttributeAsInteger("jacorb.config.log.verbosity", 0);
            if (logLevel > 2) {
                System.out.println("[ base configuration loaded from file " + home + separator + COMMON_PROPS + " ]");
            }
        }
        if ((commonProps = JacORBConfiguration.loadPropertiesFromClassPath(COMMON_PROPS)) != null) {
            loaded = true;
            this.setAttributes(commonProps);
            logLevel = this.getAttributeAsInteger("jacorb.config.log.verbosity", 0);
            if (logLevel > 2) {
                System.out.println("[ base configuration loaded from classpath orb.properties ]");
            }
        }
        if ((configDir = this.getAttribute("jacorb.config.dir", EMPTY_STR)).length() == 0) {
            configDir = this.getAttribute("jacorb.home", EMPTY_STR);
        }
        if (configDir.length() != 0) {
            configDir = configDir + separator + "etc";
        } else {
            logLevel = this.getAttributeAsInteger("jacorb.config.log.verbosity", 0);
            if (logLevel > 0) {
                System.err.println("[ jacorb.home unset! Will use '.' ]");
            }
            configDir = ".";
        }
        String propFileName = configDir + separator + name + fileSuffix;
        Properties orbConfig = JacORBConfiguration.loadPropertiesFromFile(propFileName);
        if (orbConfig != null) {
            this.setAttributes(orbConfig);
            loaded = true;
            logLevel = this.getAttributeAsInteger("jacorb.config.log.verbosity", 0);
            if (logLevel > 2) {
                System.out.println("[ configuration " + name + " loaded from file " + propFileName + " ]");
            }
        } else {
            logLevel = this.getAttributeAsInteger("jacorb.config.log.verbosity", 0);
            if (logLevel > 0) {
                System.err.println("[ File " + propFileName + " for configuration " + name + " not found ]");
            }
        }
        if (!(customPropFileNames = this.getAttributeList("custom.props")).isEmpty()) {
            Iterator iter = customPropFileNames.iterator();
            while (iter.hasNext()) {
                String fileName = (String)iter.next();
                Properties customProps = JacORBConfiguration.loadPropertiesFromFile(fileName);
                if (customProps != null) {
                    this.setAttributes(customProps);
                    loaded = true;
                    logLevel = this.getAttributeAsInteger("jacorb.config.log.verbosity", 0);
                    if (logLevel <= 2) continue;
                    System.out.println("[ custom properties loaded from file " + fileName + " ]");
                    continue;
                }
                if (logLevel <= 0) continue;
                System.err.println("[ custom properties not found in " + fileName + " ]");
            }
        }
        if ((orbConfig = JacORBConfiguration.loadPropertiesFromClassPath(name + fileSuffix)) != null) {
            this.setAttributes(orbConfig);
            loaded = true;
            logLevel = this.getAttributeAsInteger("jacorb.config.log.verbosity", 0);
            if (logLevel > 2) {
                System.out.println("[ configuration " + name + " loaded from classpath]");
            }
        }
        this.setAttributes(System.getProperties());
        if (orbProperties != null) {
            loaded = true;
            this.setAttributes(orbProperties);
        }
        if (!loaded) {
            System.out.println("[ No configuration properties found for configuration " + name + " ]");
        }
    }

    private void initApplet(String name, Properties orbProperties) throws ConfigurationException {
        List customPropFileNames;
        String propFileName;
        Properties orbConfig;
        if (name == null) {
            throw new ConfigurationException("Illegal null value for ORB name!");
        }
        boolean loaded = false;
        this.setAttributes(orbProperties);
        int logLevel = this.getAttributeAsInteger("jacorb.config.log.verbosity", 0);
        Properties commonProps = JacORBConfiguration.loadPropertiesFromClassPath(COMMON_PROPS);
        if (commonProps != null) {
            loaded = true;
            this.setAttributes(commonProps);
            logLevel = this.getAttributeAsInteger("jacorb.config.log.verbosity", 0);
            if (logLevel > 2) {
                System.out.println("[ base configuration loaded from classpath orb.properties ]");
            }
        }
        if ((orbConfig = JacORBConfiguration.loadPropertiesFromClassPath(propFileName = name + fileSuffix)) != null) {
            this.setAttributes(orbConfig);
            loaded = true;
            logLevel = this.getAttributeAsInteger("jacorb.config.log.verbosity", 0);
            if (logLevel > 2) {
                System.out.println("[ configuration " + name + " loaded from classpath " + propFileName + " ]");
            }
        } else {
            logLevel = this.getAttributeAsInteger("jacorb.config.log.verbosity", 0);
            if (logLevel > 0) {
                System.err.println("[ File " + propFileName + " for configuration " + name + " not found in classpath]");
            }
        }
        if (!(customPropFileNames = this.getAttributeList("custom.props")).isEmpty()) {
            Iterator iter = customPropFileNames.iterator();
            while (iter.hasNext()) {
                String fileName = (String)iter.next();
                Properties customProps = JacORBConfiguration.loadPropertiesFromClassPath(fileName);
                if (customProps != null) {
                    this.setAttributes(customProps);
                    loaded = true;
                    logLevel = this.getAttributeAsInteger("jacorb.config.log.verbosity", 0);
                    if (logLevel <= 2) continue;
                    System.out.println("[ custom properties loaded from classpath " + fileName + " ]");
                    continue;
                }
                if (logLevel <= 0) continue;
                System.err.println("[ custom properties " + fileName + "not found in classpath ]");
            }
        }
        if (orbProperties != null) {
            loaded = true;
            this.setAttributes(orbProperties);
        }
        if (!loaded) {
            System.out.println("[ No configuration properties found for configuration " + name + " ]");
        }
    }

    void setAttributes(Properties properties) {
        Iterator<Object> iter = properties.keySet().iterator();
        while (iter.hasNext()) {
            String key;
            Object value;
            Object k = iter.next();
            if (!(k instanceof String) || !((value = properties.get(key = (String)k)) instanceof String) && value != null) continue;
            this.setAttribute(key, (String)value);
        }
    }

    private static Properties loadPropertiesFromFile(String fileName) {
        try {
            FileInputStream in = new FileInputStream(fileName);
            Properties result = new Properties();
            result.load(in);
            ((InputStream)in).close();
            return result;
        }
        catch (FileNotFoundException ex) {
            return null;
        }
        catch (IOException ex) {
            System.out.println("could not read config file: " + fileName);
            ex.printStackTrace();
            return null;
        }
    }

    private static Properties loadPropertiesFromClassPath(String name) {
        Properties result = null;
        try {
            URL url = Thread.currentThread().getContextClassLoader().getResource(name);
            if (url != null) {
                result = new Properties();
                InputStream in = url.openStream();
                result.load(in);
                in.close();
            }
        }
        catch (FileNotFoundException ex) {
        }
        catch (IOException ioe) {
            System.out.println("could not read config file: " + name);
            ioe.printStackTrace();
        }
        return result;
    }

    private void initLogging() {
        String logFileName = this.getAttribute("jacorb.logfile", EMPTY_STR);
        int maxLogSize = this.getAttributeAsInteger("jacorb.logfile.maxLogSize", 0);
        if (!logFileName.equals(EMPTY_STR) && logFileName.endsWith("$implname")) {
            logFileName = logFileName.substring(0, logFileName.length() - 9);
            logFileName = !this.getAttribute("jacorb.implname", EMPTY_STR).equals(EMPTY_STR) ? logFileName + this.getAttribute("jacorb.implname", EMPTY_STR) : logFileName + "log";
        }
        String clzName = this.getAttribute("jacorb.log.loggerFactory", EMPTY_STR);
        Class loggerFactoryClz = null;
        try {
            loggerFactoryClz = !clzName.equals(EMPTY_STR) ? ObjectUtil.classForName(clzName) : ObjectUtil.classForName("org.jacorb.config.LogKitLoggerFactory");
            this.loggerFactory = (LoggerFactory)loggerFactoryClz.newInstance();
            this.loggerFactory.configure(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.loggerFactory == null) {
            System.err.println("Configuration Error, could not create logger!");
        }
        if (!logFileName.equals(EMPTY_STR)) {
            try {
                this.loggerFactory.setDefaultLogFile(logFileName, maxLogSize);
                this.logger = this.loggerFactory.getNamedLogger("jacorb", logFileName, maxLogSize);
            }
            catch (IOException e) {
                this.logger = this.loggerFactory.getNamedRootLogger("jacorb");
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Could not create logger with file target: " + logFileName + ", falling back to console log!");
                }
            }
        } else {
            this.logger = this.loggerFactory.getNamedRootLogger("jacorb");
        }
    }

    public ORB getORB() {
        return this.orb;
    }

    public Logger getNamedLogger(String name) {
        return this.loggerFactory.getNamedLogger(name);
    }

    public String getLoggerName(Class clz) {
        String clazzName = clz.getName();
        String packageName = clazzName.substring(0, clazzName.lastIndexOf(46));
        if (packageName != null && packageName.startsWith("org.jacorb")) {
            return packageName.substring(4);
        }
        return packageName;
    }

    public List getAttributeList(String key) {
        ArrayList<String> result = new ArrayList<String>();
        String value = null;
        try {
            value = this.getAttribute(key);
        }
        catch (ConfigurationException ce) {
            // empty catch block
        }
        if (value != null) {
            StringTokenizer tok = new StringTokenizer(value, ",");
            while (tok.hasMoreTokens()) {
                result.add(tok.nextToken().trim());
            }
        }
        return result;
    }

    public Object getAttributeAsObject(String key) throws ConfigurationException {
        String className = this.getAttribute(key, null);
        if (className != null && className.length() > 0) {
            try {
                Class c = ObjectUtil.classForName(className);
                return c.newInstance();
            }
            catch (Exception e) {
                throw new ConfigurationException("Unable to build class from key >" + key + "<: " + e);
            }
        }
        return null;
    }

    public boolean getAttributeAsBoolean(String key) throws ConfigurationException {
        String s = this.getAttribute(key);
        if (s != null && s.length() > 0) {
            return ON.equals(s = s.trim().toLowerCase()) || TRUE.equals(s);
        }
        return false;
    }

    public boolean getAttributeAsBoolean(String key, boolean defaultValue) {
        String s = this.getAttribute(key, EMPTY_STR);
        if (s.length() > 0) {
            return ON.equals(s = s.trim().toLowerCase()) || TRUE.equals(s);
        }
        return defaultValue;
    }
}

