/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.concurrent.atomic;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import javassist.runtime.Desc;
import org.jboss.lang.ExceptionHelper;
import org.jboss.lang.JBossStringBuilder;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AtomicIntegerFieldUpdater<T> {
    public static <U> AtomicIntegerFieldUpdater<U> newUpdater(Class<U> tClass, String fieldName) {
        return new Implementation<U>(tClass, fieldName);
    }

    protected AtomicIntegerFieldUpdater() {
    }

    public int addAndGet(T obj, int delta) {
        int update;
        int expect;
        while (!this.compareAndSet(obj, expect = this.get(obj), update = expect + delta)) {
        }
        return update;
    }

    public abstract boolean compareAndSet(T var1, int var2, int var3);

    public int decrementAndGet(T obj) {
        int update;
        int expect;
        while (!this.compareAndSet(obj, expect = this.get(obj), update = expect - 1)) {
        }
        return update;
    }

    public abstract int get(T var1);

    public int getAndAdd(T obj, int delta) {
        int update;
        int expect;
        while (!this.compareAndSet(obj, expect = this.get(obj), update = expect + delta)) {
        }
        return expect;
    }

    public int getAndDecrement(T obj) {
        int update;
        int expect;
        while (!this.compareAndSet(obj, expect = this.get(obj), update = expect - 1)) {
        }
        return expect;
    }

    public int getAndIncrement(T obj) {
        int update;
        int expect;
        while (!this.compareAndSet(obj, expect = this.get(obj), update = expect + 1)) {
        }
        return expect;
    }

    public int getAndSet(T obj, int newValue) {
        int expect;
        while (!this.compareAndSet(obj, expect = this.get(obj), newValue)) {
        }
        return expect;
    }

    public int incrementAndGet(T obj) {
        int update;
        int expect;
        while (!this.compareAndSet(obj, expect = this.get(obj), update = expect + 1)) {
        }
        return update;
    }

    public abstract void set(T var1, int var2);

    public abstract boolean weakCompareAndSet(T var1, int var2, int var3);

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Implementation<T>
    extends AtomicIntegerFieldUpdater<T> {
        private Class<T> tClass;
        private String fieldName;
        private Field field;

        public Implementation(Class<T> tClass, String fieldName) {
            if (tClass == null) {
                throw new IllegalArgumentException("Null class");
            }
            if (fieldName == null) {
                throw new IllegalArgumentException("Null field name");
            }
            this.tClass = tClass;
            this.fieldName = fieldName;
            try {
                this.field = tClass.getDeclaredField(fieldName);
            }
            catch (Exception e) {
                Exception exception = e;
                String string = new JBossStringBuilder().append("Cannot find field class=").append(tClass.getName()).append(" field=").append(fieldName).toString();
                Object var4_6 = null;
                Throwable throwable = null;
                throwable = ExceptionHelper.createExceptionWithCause(Desc.getClazz((String)"java.lang.IllegalArgumentException"), string, exception);
                throw throwable;
            }
            if (Integer.TYPE != this.field.getType()) {
                throw new IllegalArgumentException(new JBossStringBuilder().append("Field is not a int class=").append(tClass.getName()).append(" field=").append(fieldName).toString());
            }
            if (!Modifier.isVolatile(this.field.getModifiers())) {
                throw new IllegalArgumentException(new JBossStringBuilder().append("Field is not volatile class=").append(tClass.getName()).append(" field=").append(fieldName).toString());
            }
            this.field.setAccessible(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean compareAndSet(T obj, int expect, int update) {
            try {
                Implementation implementation = this;
                synchronized (implementation) {
                    int value = this.field.getInt(obj);
                    if (value != expect) {
                        return false;
                    }
                    this.field.setInt(obj, update);
                    return true;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(new JBossStringBuilder().append("Unexpected error class=").append(this.tClass.getName()).append(" field=").append(this.fieldName).toString(), e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int get(T obj) {
            try {
                Implementation implementation = this;
                synchronized (implementation) {
                    return this.field.getInt(obj);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(new JBossStringBuilder().append("Unexpected error class=").append(this.tClass.getName()).append(" field=").append(this.fieldName).toString(), e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set(T obj, int newValue) {
            try {
                Implementation implementation = this;
                synchronized (implementation) {
                    this.field.setInt(obj, newValue);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(new JBossStringBuilder().append("Unexpected error class=").append(this.tClass.getName()).append(" field=").append(this.fieldName).toString(), e);
            }
        }

        @Override
        public boolean weakCompareAndSet(T obj, int expect, int update) {
            return this.compareAndSet(obj, expect, update);
        }
    }
}

