/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util;

import edu.emory.mathcs.backport.java.util.AbstractSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import org.jboss.lang.ClassRedirects;
import org.jboss.lang.EnumImpl;
import org.jboss.lang.JBossStringBuilder;

/*
 * Signature claims super is java.util.AbstractSet<E>, not edu.emory.mathcs.backport.java.util.AbstractSet - discarding signature.
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumSet
extends AbstractSet
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -3136546369353376452L;
    private TreeSet<E> values;
    private final Class<E> enumType;
    private final EnumImpl[] constants;

    private EnumSet(Class<E> enumType) {
        Class clazz = enumType;
        boolean bl = false;
        bl = ClassRedirects.isEnum(clazz);
        if (!bl) {
            throw new IllegalArgumentException(new JBossStringBuilder().append("Not an enum ").append(enumType).toString());
        }
        this.enumType = enumType;
        this.values = new edu.emory.mathcs.backport.java.util.TreeSet();
        clazz = enumType;
        EnumImpl[] enumImplArray = null;
        enumImplArray = ClassRedirects.getEnumConstants(clazz);
        this.constants = enumImplArray;
    }

    public static <E extends Enum<E>> EnumSet<E> noneOf(Class<E> enumType) {
        return new EnumSet(enumType);
    }

    public static <E extends Enum<E>> EnumSet<E> allOf(Class<E> enumType) {
        EnumSet result = new EnumSet(enumType);
        for (EnumImpl e : result.constants) {
            result.add((E)e);
        }
        return result;
    }

    public static <E extends Enum<E>> EnumSet<E> copyOf(EnumSet<E> s) {
        return s.clone();
    }

    public static <E extends Enum<E>> EnumSet<E> copyOf(Collection<E> c) {
        if (c instanceof EnumSet) {
            return ((EnumSet)((Object)c)).clone();
        }
        if (c.isEmpty()) {
            throw new IllegalArgumentException("Empty collection");
        }
        Iterator<E> iter = c.iterator();
        EnumImpl first = (EnumImpl)iter.next();
        EnumSet<EnumImpl> result = EnumSet.of(first);
        while (iter.hasNext()) {
            result.add((EnumImpl)iter.next());
        }
        return result;
    }

    public static <E extends Enum<E>> EnumSet<E> complementOf(EnumSet<E> s) {
        EnumSet<E> result = EnumSet.allOf(s.enumType);
        result.removeAll(s);
        return result;
    }

    public static <E extends Enum<E>> EnumSet<E> of(E e) {
        EnumSet result = new EnumSet(((EnumImpl)((Object)e)).getDeclaringClass());
        result.add(e);
        return result;
    }

    public static <E extends Enum<E>> EnumSet<E> of(E e1, E e2) {
        EnumSet result = new EnumSet(((EnumImpl)((Object)e1)).getDeclaringClass());
        result.add(e1);
        result.add(e2);
        return result;
    }

    public static <E extends Enum<E>> EnumSet<E> of(E e1, E e2, E e3) {
        EnumSet result = new EnumSet(((EnumImpl)((Object)e1)).getDeclaringClass());
        result.add(e1);
        result.add(e2);
        result.add(e3);
        return result;
    }

    public static <E extends Enum<E>> EnumSet<E> of(E e1, E e2, E e3, E e4) {
        EnumSet result = new EnumSet(((EnumImpl)((Object)e1)).getDeclaringClass());
        result.add(e1);
        result.add(e2);
        result.add(e3);
        result.add(e4);
        return result;
    }

    public static <E extends Enum<E>> EnumSet<E> of(E e1, E e2, E e3, E e4, E e5) {
        EnumSet result = new EnumSet(((EnumImpl)((Object)e1)).getDeclaringClass());
        result.add(e1);
        result.add(e2);
        result.add(e3);
        result.add(e4);
        result.add(e5);
        return result;
    }

    public static <E extends Enum<E>> EnumSet<E> of(E first, E ... rest) {
        EnumSet<E> result = EnumSet.of(first);
        for (E e : rest) {
            result.add(e);
        }
        return result;
    }

    public static <E extends Enum<E>> EnumSet<E> range(E from, E to) {
        EnumSet result = new EnumSet(((EnumImpl)((Object)from)).getDeclaringClass());
        for (int i = ((EnumImpl)((Object)from)).ordinal(); i <= ((EnumImpl)((Object)to)).ordinal(); ++i) {
            result.add((E)result.constants[i]);
        }
        return result;
    }

    public EnumSet<E> clone() {
        EnumSet result;
        try {
            result = (EnumSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
        result.values = (edu.emory.mathcs.backport.java.util.TreeSet)this.values.clone();
        return result;
    }

    public Iterator<E> iterator() {
        return this.values.iterator();
    }

    public int size() {
        return this.values.size();
    }

    public boolean add(E o) {
        return this.values.add(o);
    }
}

