/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.Map;
import org.hibernate.cfg.ClassPropertyHolder;
import org.hibernate.cfg.CollectionPropertyHolder;
import org.hibernate.cfg.ComponentPropertyHolder;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.PropertyData;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.annotations.EntityBinder;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.reflection.XClass;
import org.hibernate.reflection.XProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyHolderBuilder {
    private PropertyHolderBuilder() {
    }

    public static PropertyHolder buildPropertyHolder(XClass clazzToProcess, PersistentClass persistentClass, EntityBinder entityBinder, ExtendedMappings mappings) {
        return new ClassPropertyHolder(persistentClass, clazzToProcess, entityBinder, mappings);
    }

    public static PropertyHolder buildPropertyHolder(Component component, String path, PropertyData inferredData, PropertyHolder parent, ExtendedMappings mappings) {
        return new ComponentPropertyHolder(component, path, inferredData, parent, mappings);
    }

    public static PropertyHolder buildPropertyHolder(Collection collection, String path, XClass clazzToProcess, XProperty property, ExtendedMappings mappings) {
        return new CollectionPropertyHolder(collection, path, clazzToProcess, property, mappings);
    }

    public static PropertyHolder buildPropertyHolder(PersistentClass persistentClass, Map<String, Join> joins, ExtendedMappings mappings) {
        return new ClassPropertyHolder(persistentClass, null, joins, mappings);
    }
}

