/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.webservice.server;

// $Id:ServiceException.java,v 1.0, 2005-06-24 19:16:00Z, Robert Worsnop$

import org.jboss.axis.AxisFault;
import org.jboss.logging.Logger;

/**
 * A simple exception wrapper that does logging
 *
 * @author Thomas.Diesler@jboss.org
 * @since 15-April-2004
 */
public class ServiceException extends AxisFault
{
   // provide logging
   private static final Logger log = Logger.getLogger(ServiceException.class);

   public ServiceException(String message)
   {
      super(message);
      log.error(message);
   }

   public ServiceException(String message, Throwable t)
   {
      super(message, t);
      log.error(message, t);
   }

   public ServiceException(Exception target)
   {
      super(target);
      log.error(target);
   }
}
