/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

// $Id:JMXInvokerEndpoint.java,v 1.0, 2005-06-24 19:10:09Z, Robert Worsnop$
package org.jboss.webservice.server;

// $Id:JMXInvokerEndpoint.java,v 1.0, 2005-06-24 19:10:09Z, Robert Worsnop$

import org.jboss.axis.MessageContext;
import org.jboss.logging.Logger;

import java.lang.reflect.Method;

/**
 * A generic service endpoint POJO that delegates invocations to an arbitary MBean.
 *
 * @author Thomas.Diesler@jboss.org
 * @since 30-Sep-2004
 */
public class JMXInvokerEndpoint
{
   // provide logging
   private Logger log = Logger.getLogger(JMXInvokerEndpoint.class);

   /**
    * This method encapsulates the method invocation.
    *
    * @param msgContext MessageContext
    * @param method     the target method.
    * @param obj        the target object
    * @param argValues  the method arguments
    */
   protected Object invoke(MessageContext msgContext, Method method, Object obj, Object[] argValues)
           throws Exception
   {
      log.debug("Invoke JMX: " + method);

      // invoke the bean method
      Object retObj = null;
      return retObj;
   }
}
