/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.webservice.metadata;

// $Id:WebservicesFactory.java,v 1.0, 2005-06-24 19:19:12Z, Robert Worsnop$

import org.jboss.logging.Logger;
import org.jboss.webservice.metadata.InitParamMetaData;
import org.jboss.webservice.metadata.HandlerMetaData;
import org.jboss.xml.binding.ContentNavigator;
import org.jboss.xml.binding.ObjectModelFactory;
import org.xml.sax.Attributes;

import java.net.URLClassLoader;

/**
 * A JBossXB factory for {@link WebservicesMetaData}
 *
 * @author Thomas.Diesler@jboss.org
 * @since 16-Apr-2004
 */
public class WebservicesFactory
        implements ObjectModelFactory
{
   // provide logging
   private static final Logger log = Logger.getLogger(WebservicesFactory.class);

   // The url class loader for resources
   private URLClassLoader resourceLoader;

   public WebservicesFactory(URLClassLoader resourceLoader)
   {
      this.resourceLoader = resourceLoader;
   }

   /**
    * This method is called on the factory by the object model builder when the parsing starts.
    *
    * @return the root of the object model.
    */
   public Object newRoot(Object root,
                               ContentNavigator navigator,
                               String namespaceURI,
                               String localName,
                               Attributes attrs)
   {
      return new WebservicesMetaData(resourceLoader);
   }

   /**
    * Called when parsing of a new element started.
    */
   public Object newChild(WebservicesMetaData webservices, ContentNavigator navigator, String namespaceURI, String localName,
                          Attributes attrs)
   {
      if ("webservice-description".equals(localName))
         return new WebserviceDescriptionMetaData(webservices);
      else
         return null;
   }

   /**
    * Called when parsing character is complete.
    */
   public void addChild(WebservicesMetaData webservices,
                        WebserviceDescriptionMetaData webserviceDescription,
                        ContentNavigator navigator, String namespaceURI, String localName)
   {
      webservices.addWebserviceDescription(webserviceDescription);
   }

   /**
    * Called when parsing of a new element started.
    */
   public Object newChild(WebserviceDescriptionMetaData webserviceDescription, ContentNavigator navigator, String namespaceURI, String localName,
                          Attributes attrs)
   {
      if ("port-component".equals(localName))
         return new PortComponentMetaData(webserviceDescription);
      else
         return null;
   }

   /**
    * Called when parsing character is complete.
    */
   public void addChild(WebserviceDescriptionMetaData webserviceDescription,
                        PortComponentMetaData portComponent,
                        ContentNavigator navigator, String namespaceURI, String localName)
   {
      webserviceDescription.addPortComponent(portComponent);
   }

   /**
    * Called when parsing of a new element started.
    */
   public Object newChild(PortComponentMetaData portComponent, ContentNavigator navigator, String namespaceURI, String localName,
                          Attributes attrs)
   {
      if ("handler".equals(localName))
         return new HandlerMetaData();
      else
         return null;
   }

   /**
    * Called when parsing character is complete.
    */
   public void addChild(PortComponentMetaData portComponent, HandlerMetaData handler, ContentNavigator navigator, String namespaceURI, String localName)
   {
      portComponent.addHandler(handler);
   }

   /**
    * Called when parsing of a new element started.
    */
   public Object newChild(HandlerMetaData handler, ContentNavigator navigator, String namespaceURI, String localName,
                          Attributes attrs)
   {
      if ("init-param".equals(localName))
         return new InitParamMetaData();
      else
         return null;
   }

   /**
    * Called when parsing character is complete.
    */
   public void addChild(HandlerMetaData handler, InitParamMetaData param, ContentNavigator navigator, String namespaceURI, String localName)
   {
      handler.addInitParam(param);
   }

   /**
    * Called when a new simple child element with text value was read from the XML content.
    */
   public void setValue(WebserviceDescriptionMetaData webserviceDescription, ContentNavigator navigator, String namespaceURI, String localName, String value)
   {
      if (log.isTraceEnabled())
         log.trace("WebserviceDescriptionMetaData setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value);

      if (localName.equals("webservice-description-name"))
         webserviceDescription.setWebserviceDescriptionName(value);
      else if (localName.equals("wsdl-file"))
         webserviceDescription.setWsdlFile(value);
      else if (localName.equals("jaxrpc-mapping-file"))
         webserviceDescription.setJaxrpcMappingFile(value);
   }

   /**
    * Called when a new simple child element with text value was read from the XML content.
    */
   public void setValue(PortComponentMetaData portComponent, ContentNavigator navigator, String namespaceURI, String localName, String value)
   {
      if (log.isTraceEnabled())
         log.trace("PortComponentMetaData setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value);

      if (localName.equals("port-component-name"))
         portComponent.setPortComponentName(value);
      else if (localName.equals("wsdl-port"))
         portComponent.setWsdlPort(navigator.resolveQName(value));
      else if (localName.equals("service-endpoint-interface"))
         portComponent.setServiceEndpointInterface(value);
      else if (localName.equals("ejb-link"))
         portComponent.setEjbLink(value);
      else if (localName.equals("servlet-link"))
         portComponent.setServletLink(value);
   }

   /**
    * Called when a new simple child element with text value was read from the XML content.
    */
   public void setValue(HandlerMetaData handler, ContentNavigator navigator, String namespaceURI, String localName, String value)
   {
      if (log.isTraceEnabled())
         log.trace("HandlerMetaData setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value);

      if (localName.equals("handler-name"))
         handler.setHandlerName(value);
      else if (localName.equals("handler-class"))
         handler.setHandlerClass(value);
      else if (localName.equals("soap-header"))
         handler.addSoapHeader(navigator.resolveQName(value));
      else if (localName.equals("soap-role"))
         handler.addSoapRole(value);
   }

   /**
    * Called when a new simple child element with text value was read from the XML content.
    */
   public void setValue(InitParamMetaData param, ContentNavigator navigator, String namespaceURI, String localName, String value)
   {
      if (log.isTraceEnabled())
         log.trace("InitParamMetaData setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value);

      if (localName.equals("param-name"))
         param.setParamName(value);
      else if (localName.equals("param-value"))
         param.setParamValue(value);
   }
}
