/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

// $Id:PortComponentMetaData.java,v 1.0, 2005-06-24 19:14:08Z, Robert Worsnop$
package org.jboss.webservice.metadata;

// $Id:PortComponentMetaData.java,v 1.0, 2005-06-24 19:14:08Z, Robert Worsnop$

import javax.xml.namespace.QName;
import java.net.URL;
import java.util.ArrayList;

/**
 * XML Binding and ws4ee meta-data element for
 * <code>webservices/webservice-description/port-component</code>
 * <p/>
 * A port component is the equivalent of an ordinary Axis service (and
 * as such it constitutes the building blocks for jaxrpc services).
 * <p/>
 *
 * @author Thomas.Diesler@jboss.org
 * @since 15-April-2004
 */
public class PortComponentMetaData
{
   /**
    * The index of the webservice-description in webservices.xml
    */
   public static final String PARAMETER_WEBSERVICE_ID = "webserviceID";

   // The parent <webservice-description> element
   private WebserviceDescriptionMetaData webserviceDescription;

   /** The required <port-component-name> element
    * This name bears no relationship to the WSDL port name.
    * This name must be unique amongst all port component names in a module.
    */
   private String portComponentName;
   // The required <wsdl-port> element
   private QName wsdlPort;
   // The required <service-endpoint-interface> element
   private String serviceEndpointInterface;
   // The required <ejb-link> or <servlet-link> in the <service-impl-bean> element
   private String ejbLink;
   private String servletLink;
   // The optional <handler> elements
   private ArrayList handlers = new ArrayList();

   // The endpoint implementation bean
   private String serviceEndpointBean;

   // The updated port service URL
   private URL serviceEndpointURL;

   /**
    * Construct a new PortComponentMetaData for a given WebserviceDescriptionMetaData
    */
   public PortComponentMetaData(WebserviceDescriptionMetaData webserviceDescription)
   {
      this.webserviceDescription = webserviceDescription;
   }

   public WebserviceDescriptionMetaData getWebserviceDescription()
   {
      return webserviceDescription;
   }

   public String getPortComponentName()
   {
      return portComponentName;
   }

   public void setPortComponentName(String portComponentName)
   {
      this.portComponentName = portComponentName;
   }

   public QName getWsdlPort()
   {
      return wsdlPort;
   }

   public void setWsdlPort(QName wsdlPort)
   {
      this.wsdlPort = wsdlPort;
   }

   public String getEjbLink()
   {
      return ejbLink;
   }

   public void setEjbLink(String ejbLink)
   {
      this.ejbLink = ejbLink;
   }

   public String getServletLink()
   {
      return servletLink;
   }

   public void setServletLink(String servletLink)
   {
      this.servletLink = servletLink;
   }

   public String getServiceEndpointInterface()
   {
      return serviceEndpointInterface;
   }

   public void setServiceEndpointInterface(String serviceEndpointInterface)
   {
      this.serviceEndpointInterface = serviceEndpointInterface;
   }

   public String getServiceEndpointBean()
   {
      return serviceEndpointBean;
   }

   public void setServiceEndpointBean(String serviceEndpointBean)
   {
      this.serviceEndpointBean = serviceEndpointBean;
   }

   public void addHandler(HandlerMetaData handler)
   {
      handlers.add(handler);
   }

   public HandlerMetaData[] getHandlers()
   {
      HandlerMetaData[] array = new HandlerMetaData[handlers.size()];
      handlers.toArray(array);
      return array;
   }

   /**
    * Get the updated web service URL
    */
   public URL getServiceEndpointURL()
   {
      return serviceEndpointURL;
   }

   /**
    * Set the updated web service URL
    * <p/>
    * A call to {@link WebserviceDescriptionMetaData#updateServiceAddress(org.jboss.webservice.ServiceDeployer.ServiceLocationResolver)}
    * initializes this value
    */
   public void setServiceEndpointURL(URL serviceEndpointURL)
   {
      this.serviceEndpointURL = serviceEndpointURL;
   }
}
