/**
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.webservice.encoding.ser;

// $Id:SOAPArraySerializer.java,v 1.0, 2005-06-24 19:16:29Z, Robert Worsnop$

import org.jboss.axis.Constants;
import org.jboss.axis.encoding.ser.ArraySerializer;

import javax.xml.namespace.QName;
import java.math.BigDecimal;

/**
 * DOCUMENT ME!
 *
 * @author thomas.diesler@jboss.org
 */
public class SOAPArraySerializer extends ArraySerializer
{
   public SOAPArraySerializer(Class javaType, QName xmlType)
   {
      addComponentTypeMapping(String.class, new QName(Constants.URI_SOAP11_ENC, "string"));
      addComponentTypeMapping(Boolean.class, new QName(Constants.URI_SOAP11_ENC, "boolean"));
      addComponentTypeMapping(Float.class, new QName(Constants.URI_SOAP11_ENC, "float"));
      addComponentTypeMapping(Double.class, new QName(Constants.URI_SOAP11_ENC, "double"));
      addComponentTypeMapping(BigDecimal.class, new QName(Constants.URI_SOAP11_ENC, "decimal"));
      addComponentTypeMapping(Integer.class, new QName(Constants.URI_SOAP11_ENC, "int"));
      addComponentTypeMapping(Short.class, new QName(Constants.URI_SOAP11_ENC, "short"));
      addComponentTypeMapping(Byte.class, new QName(Constants.URI_SOAP11_ENC, "byte"));
      addComponentTypeMapping(byte[].class, new QName(Constants.URI_SOAP11_ENC, "base64"));
   }
}
