/**
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.webservice.encoding.ser;

// $Id:MetaDataBeanDeserializerFactory.java,v 1.0, 2005-06-24 19:12:22Z, Robert Worsnop$

import org.jboss.axis.encoding.Deserializer;
import org.jboss.axis.encoding.ser.BaseDeserializerFactory;
import org.jboss.webservice.deployment.BeanXMLMetaData;

import javax.xml.namespace.QName;

/** A factory for the MetaDataBeanDeserializer
 *
 * @author thomas.diesler@jboss.org
 * @version $Revision:1$
 */
public class MetaDataBeanDeserializerFactory extends BaseDeserializerFactory
{
   /** @since 4.0.2 */
   static final long serialVersionUID = -224671545135141383L;
   
   private BeanXMLMetaData metaData;

   public MetaDataBeanDeserializerFactory(Class javaType, QName xmlType)
   {
      super(MetaDataBeanDeserializer.class, xmlType, javaType);
   }

   public void setMetaData(BeanXMLMetaData metaData)
   {
      this.metaData = metaData;
   }

   protected Deserializer getSpecialized(String mechanismType)
   {
      return newMetaDataBeanDeserializer();
   }

   protected Deserializer getGeneralPurpose(String mechanismType)
   {
      return newMetaDataBeanDeserializer();
   }

   private MetaDataBeanDeserializer newMetaDataBeanDeserializer()
   {
      return new MetaDataBeanDeserializer(javaType, xmlType, metaData);
   }
}
