/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

// $Id:Stub.java,v 1.0, 2005-06-24 19:17:05Z, Robert Worsnop$
package org.jboss.webservice.client;

import java.util.Iterator;

// $Id:Stub.java,v 1.0, 2005-06-24 19:17:05Z, Robert Worsnop$


/**
 * JBossWS client stubs implement this interface.
 *
 * It provides access to the standard properties via convenience methods
 * and adds some propriatary properties as well.
 *
 * for an implementation of the interface see {@link org.jboss.webservice.client.PortProxy}
 *
 * @author Thomas.Diesler@jboss.org
 * @since 09-Nov-2004
 */
public interface Stub extends javax.xml.rpc.Stub
{
   /** Client timeout property */
   static final String CLIENT_TIMEOUT_PROPERTY = "org.jboss.webservice.client.timeout";

   String getUsername();

   void setUsername(String username);

   String getPassword();

   void setPassword(String password);

   String getEndpointAddress();

   void setEndpointAddress(String endpoint);

   Boolean getSessionMaintain();

   void setSessionMaintain(Boolean maintainSession);

   Integer getTimeout();

   void setTimeout(Integer timeout);

   void addAttachment(String contentID, Object mimepart);

   void removeAttachment(String contentID);

   Iterator getAttachmentIdentifiers();

   Object getAttachment(String contentID);
}