/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.webservice;

// $Id:PortComponentInfo.java,v 1.0, 2005-06-24 19:14:08Z, Robert Worsnop$

import org.jboss.deployment.DeploymentInfo;
import org.jboss.webservice.deployment.ServiceDescription;
import org.jboss.webservice.metadata.PortComponentMetaData;
import org.jboss.metadata.WebMetaData;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

/**
 * This object registered with the AxisService.
 * <p/>
 * The key is [deploymentName]#[port-component-name]
 *
 * @author Thomas.Diesler@jboss.org
 * @since 28-May-2004
 */
public class PortComponentInfo
{
   private DeploymentInfo di;
   private PortComponentMetaData pcMetaData;
   private ServiceDescription serviceDesc;
   private String serviceID;
   private ObjectName objectName;

   public PortComponentInfo(DeploymentInfo di, PortComponentMetaData pcMetaData)
   {
      this.di = di;
      this.pcMetaData = pcMetaData;
      this.serviceID = di.getCanonicalName() + "#" + pcMetaData.getPortComponentName();

      try
      {
         this.objectName = ObjectName.getInstance("jboss.ws4ee:port-component=" + serviceID);
      }
      catch (MalformedObjectNameException e)
      {
         throw new IllegalArgumentException("Invalid serviceID: " + serviceID);
      }
   }

   public String getServiceID()
   {
      return serviceID;
   }

   public ObjectName getObjectName()
   {
      return objectName;
   }

   public DeploymentInfo getDeploymentInfo()
   {
      return di;
   }

   public PortComponentMetaData getPortComponentMetaData()
   {
      return pcMetaData;
   }

   public String getServiceEndpointURL()
   {
      return pcMetaData.getServiceEndpointURL().toExternalForm();
   }

   public void setServiceDesc(ServiceDescription serviceDesc)
   {
      this.serviceDesc = serviceDesc;
   }

   public ServiceDescription getServiceDescription()
   {
      return serviceDesc;
   }

   /** Get the port component classloader */
   public ClassLoader getPortComponentClassLoader()
   {
      if (di.metaData instanceof WebMetaData)
         return ((WebMetaData)di.metaData).getContextLoader();
      else
         return di.ucl;
   }

   /**
    * Returns a string representation of the object.
    */
   public String toString()
   {
      return "[id=" + serviceID + ",address=" + pcMetaData.getServiceEndpointURL() + "]";
   }
}

