/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.webservice;

// $Id:PortComponent.java,v 1.0, 2005-06-24 19:14:08Z, Robert Worsnop$


/**
 * This object registered with MBeanServer
 * <p/>
 * The key is [deploymentName]#[port-component-name]
 *
 * @author Thomas.Diesler@jboss.org
 * @jmx.mbean description="Web Service Port Component"
 * @since 17-Jun-2004
 */
public class PortComponent implements PortComponentMBean
{
   private String serviceID;

   public PortComponent(PortComponentInfo pcInfo)
   {
      this.serviceID = pcInfo.getServiceID();
   }

   /**
    * @jmx.managed-attribute
    */
   public String getServiceID()
   {
      return serviceID;
   }
}

