/*
 * JBoss, the OpenSource WebOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.web.loadbalancer.util;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.jboss.web.loadbalancer.scheduler.Host;

/**
 * A class that holds all information about a request.
 *
 * @author Thomas Peuss <jboss@peuss.de>
 * @version $Revision:1$
 */
public class Request
{
  private HttpServletRequest request;
  private HttpServletResponse response;
  private int requestMethod;
  private HttpMethod method;
  private Host host;
  private HttpClient client;

  public Request(HttpServletRequest request,
                 HttpServletResponse response, int requestMethod)
  {
    this.request=request;
    this.response=response;
    this.requestMethod=requestMethod;
  }

  public HttpServletRequest getRequest()
  {
    return request;
  }

  public int getRequestMethod()
  {
    return requestMethod;
  }

  public HttpServletResponse getResponse()
  {
    return response;
  }

  public HttpMethod getMethod()
  {
    return method;
  }

  public void setMethod(HttpMethod method)
  {
    this.method = method;
  }

  public Host getHost()
  {
    return host;
  }

  public void setHost(Host host)
  {
    this.host = host;
  }

  public HttpClient getClient()
  {
    return client;
  }

  public void setClient(HttpClient client)
  {
    this.client = client;
  }
}