/*
 * JBoss, the OpenSource WebOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.web.loadbalancer.scheduler;

import javax.management.Notification;

/**
 * A JMX-Notification that informs listeners about the fact that
 * the state of a node changed.
 * @author Thomas Peuss <jboss@peuss.de>
 * @version $Revision:1$
 */
public class HostStateChangedNotification extends Notification
{
  private static long sequenceId=0L;

  public HostStateChangedNotification(Host source, String message)
  {
    super(HostStateChangedNotification.class.getName(), source, sequenceId++, message);
  }
}