/*
 * JBoss, the OpenSource WebOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.web.loadbalancer.monitor;

import org.apache.commons.httpclient.HttpMethod;
import gnu.regexp.RE;
import gnu.regexp.REException;

/**
 * A Monitor implementation that does a RegExp-check of the content.
 *
 * @author Thomas Peuss <jboss@peuss.de>
 * @version $Revision:1$
 * @jmx:mbean name="jboss.web.loadbalancer: service=ECVMonitor"
 *            extends="org.jboss.web.loadbalancer.monitor.AbstractMonitorMBean"
 */
public class ECVMonitorService
    extends AbstractMonitor
    implements ECVMonitorServiceMBean
{
  protected RE regExp;

  protected boolean checkHostStatus(HttpMethod method)
  {
    return matchRegExp(method.getResponseBodyAsString());
  }

  protected boolean matchRegExp(String string)
  {
    // try to match regexp
    if (regExp.getMatch(string) == null)
    {
      log.error("RegExp \"" + regExp + "\" does not match server output");
      return false;
    }
    return true;
  }

  /**
   * @jmx:managed-attribute
   */
  public void setRegExp(String regExp) throws REException
  {
    this.regExp = new RE(regExp);
  }

  /**
   * @jmx:managed-attribute
   */
  public String getRegExp()
  {
    return regExp.toString();
  }
}