/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/

package org.jboss.services.deployment.metadata;

import java.io.Serializable;

/**
 * Simple POJO class to model XML data
 * 
 * @author  <a href="mailto:dimitris@jboss.org">Dimitris Andreadis</a>
 * 
 * @version $Revision:1$
 */
public class PropertyInfo
   implements Serializable
{
   /** @since 4.0.2 */
   private static final long serialVersionUID = -1246926015774516936L;
      
   private String  name;
   private String  type;
   private boolean optional;
   private String  description;
   private Object  defaultValue;
   
   public PropertyInfo()
   {
      // empty
   }
   
   public PropertyInfo(PropertyInfo that)
   {
      this.name = that.name;
      this.type = that.type;
      this.optional = that.optional;
      this.description = that.description;
      this.defaultValue = that.defaultValue; // shouldn't we copy this?
   }
   
   public PropertyInfo(String name, String type, boolean optional, String description, Object defaultValue)
   {
      this.name = name;
      this.type = type;
      this.optional = optional;
      this.description = description;
      this.defaultValue = defaultValue;
   }
   
   public Object getDefaultValue()
   {
      return defaultValue;
   }
   
   public void setDefaultValue(Object defaultValue)
   {
      this.defaultValue = defaultValue;
   }
   
   public String getDescription()
   {
      return description;
   }
   
   public void setDescription(String description)
   {
      this.description = description;
   }
   
   public String getName()
   {
      return name;
   }
   
   public void setName(String name)
   {
      this.name = name;
   }
   
   public boolean isOptional()
   {
      return optional;
   }
   
   public void setOptional(boolean optional)
   {
      this.optional = optional;
   }
   
   public String getType()
   {
      return type;
   }
   
   public void setType(String type)
   {
      this.type = type;
   }
   
   public String toString()
   {
      StringBuffer sbuf = new StringBuffer(256);
      
      sbuf.append('[')
      .append("name=").append(name)
      .append(", type=").append(type)
      .append(", optional=").append(optional)
      .append(", description=").append(description)
      .append(", defaultValue=").append(defaultValue)      
      .append(']');
      
      return sbuf.toString();      
   }     
}
