/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.monitor.alerts;

import java.util.Map;

import javax.management.Notification;

import org.jboss.monitor.JBossMonitorNotification;
import org.jboss.util.Strings;

/**
 * Comment
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision:1$
 *
 **/
public class ConsoleAlertListener extends JBossAlertListener implements ConsoleAlertListenerMBean
{
   protected String messageTemplate;

   public void handleNotification(Notification notification,
                                  Object handback)
   {
      if (!(notification instanceof JBossMonitorNotification)) return;
      Map substitutions = ((JBossMonitorNotification)notification).substitutionMap();
      String message = Strings.subst(messageTemplate, substitutions, "%(", ")");
      log.info(message);
   }

   public String getMessageTemplate()
   {
      return messageTemplate;
   }

   public void setMessageTemplate(String messageTemplate)
   {
      this.messageTemplate = messageTemplate;
   }

}
