/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.jmx.adaptor.snmp.config.notification;

/**
 * Simple POJO class to model XML data
 * 
 * @author  <a href="mailto:dimitris@jboss.org">Dimitris Andreadis</a>
 * 
 * @version $Revision:1$
 */
public class Mapping
{
   // Private Data --------------------------------------------------

   private String      notificationType;
   private int         generic;
   private int         specific;
   private String      enterprise;
   private VarBindList varBindList;

   // Constructors -------------------------------------------------
   
  /**
   * Default CTOR
   */
  public Mapping()
  {
     // empty
  }

  // Accessors/Modifiers -------------------------------------------  
  
   public String getEnterprise()
   {
      return enterprise;
   }

   public int getGeneric()
   {
      return generic;
   }

   public String getNotificationType()
   {
      return notificationType;
   }

   public int getSpecific()
   {
      return specific;
   }

   public VarBindList getVarBindList()
   {
      return varBindList;
   }

   public void setEnterprise(String enterprise)
   {
      this.enterprise = enterprise;
   }

   public void setGeneric(int generic)
   {
      this.generic = generic;
   }
   
   public void setNotificationType(String notificationType)
   {
      this.notificationType = notificationType;
   }

   public void setSpecific(int specific)
   {
      this.specific = specific;
   }

   public void setVarBindList(VarBindList varBindList)
   {
      this.varBindList = varBindList;
   }
   
   // Object overrides ----------------------------------------------
   
   public String toString()
   {
      StringBuffer sbuf = new StringBuffer(256);
      
      sbuf.append('[')
      .append("notificationType=").append(notificationType)
      .append(", generic=").append(generic)
      .append(", specific=").append(specific)
      .append(", enterprise=").append(enterprise)
      .append(", varBindList=").append(varBindList)      
      .append(']');
      
      return sbuf.toString();      
   }   
}
