/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.jmx.adaptor.snmp.agent;

import javax.management.MBeanServer;

import org.jboss.logging.Logger;
import org.opennms.protocols.snmp.SnmpAgentHandler;

/**
 * Interface that must be implemented by classes
 * that provide agent get/set functionality
 * 
 * @version $Revision:1$
 *  
 * @author  <a href="mailto:dimitris@jboss.org">Dimitris Andreadis</a>
**/
public interface RequestHandler
   extends SnmpAgentHandler
{
   /**
    * Perform initialization, possibly by parsing
    * mapping information from resourceName
    * 
    * @param resourceName file containing mappinginfo
    * @param server the mbean server to forward mapped get/set requests 
    * @param logger the shared logger to use
    * @param uptime the snmp agent uptime
    * @throws Exception in case of initialization problem
    */
   public void initialize(String resourceName, MBeanServer server, Logger loggger, Clock uptime)
      throws Exception;

} // RequestHandler
