/*
 * JBoss, Home of Professional Open Source
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.web.tomcat.tc5;

import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.LifecycleException;

/**
 * Override the tomcat WebappLoader to set the default class loader to the
 * WebAppClassLoader and pass the filtered packages to the WebAppClassLoader.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class WebAppLoader extends WebappLoader
{
   private String[] filteredPackages = {
      "org.apache.commons.logging"
   };

   public WebAppLoader()
   {
      super();
      setLoaderClass(WebAppClassLoader.class.getName());
   }

   public WebAppLoader(ClassLoader parent, String[] filteredPackages)
   {
      super(parent);
      setLoaderClass(WebAppClassLoader.class.getName());
      this.filteredPackages = filteredPackages;
   }

   /**
    * Override to apply the filteredPackages to the jboss WebAppClassLoader
    * 
    * @throws LifecycleException
    */ 
   public void start() throws LifecycleException
   {
      super.start();
      ClassLoader loader = getClassLoader();
      if( loader instanceof WebAppClassLoader )
      {
         WebAppClassLoader webLoader = (WebAppClassLoader) loader;
         webLoader.setFilteredPackages(filteredPackages);
      }
   }
}
