/*
 * JBoss, Home of Professional Open Source
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.web.tomcat.tc5;

import org.apache.catalina.loader.WebappClassLoader;
import org.jboss.logging.Logger;

/**
 * Subclass the tomcat web app class loader to override the filter method
 * to exclude classes which cannot be override by the web app due to their
 * use in the tomcat web container/integration.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class WebAppClassLoader extends WebappClassLoader
{
   static Logger log = Logger.getLogger(WebAppClassLoader.class);
   private String[] filteredPackages = {
      "org.apache.commons.logging"
   };

   public WebAppClassLoader()
   {
   }

   public WebAppClassLoader(ClassLoader parent)
   {
      super(parent);
   }

   public String[] getFilteredPackages()
   {
      return filteredPackages;
   }
   public void setFilteredPackages(String[] pkgs)
   {
      this.filteredPackages = pkgs;
   }

   /**
    * Overriden to filter out classes in the packages listed in the
    * filteredPackages settings.
    * 
    * @param name
    * @return true if the class should be loaded from the parent class loader,
    *    false if it can be loaded from this class loader.
    */ 
   protected boolean filter(String name)
   {
      boolean excludeClass = super.filter(name);
      if( excludeClass == false )
      {
         // Check class against our filtered packages
         int length = filteredPackages != null ? filteredPackages.length : 0;
         for(int n = 0; n < length; n ++)
         {
            String pkg = filteredPackages[n];
            if( name.startsWith(pkg) )
            {
               excludeClass = true;
               break;
            }
         }
      }
      log.trace("filter name="+name+", exclude="+excludeClass);
      return excludeClass;
   }
}
