/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.web.tomcat.security;

import java.io.IOException;
import java.security.CodeSource;
import javax.security.jacc.PolicyContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.jboss.logging.Logger;

/**
 * A Valve that sets the JACC context id and HttpServletRequest policy
 * context handler value. The context id needs to be established prior to
 * any authorization valves.
 *
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class JaccContextValve extends ValveBase
{
   private static Logger log = Logger.getLogger(JaccContextValve.class);
   public static ThreadLocal activeCS = new ThreadLocal();

   /** The web app metadata */
   private String contextID;
   /** The web app deployment code source */
   private CodeSource warCS;
   private boolean trace;

   public JaccContextValve(String contextID, CodeSource cs)
   {
      this.contextID = contextID;
      this.warCS = cs;
      this.trace = log.isTraceEnabled();
   }

   public void invoke(Request request, Response response)
      throws IOException, ServletException
   {
      activeCS.set(warCS);
      HttpServletRequest httpRequest = (HttpServletRequest) request.getRequest();

      try
      {
         // Set the JACC context id
         PolicyContext.setContextID(contextID);
         // Set the JACC HttpServletRequest PolicyContextHandler data
         HttpServletRequestPolicyContextHandler.setRequest(httpRequest);
         // Perform the request
         getNext().invoke(request, response);
      }
      finally
      {
         activeCS.set(null);
      }
   }

}
