/*
 * JBoss, the OpenSource WebOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.web.tomcat.security;

import java.io.IOException;

import javax.servlet.ServletException;

import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;

/**
 * A Tomcat Valve that obtains the client's HttpServletRequest and saves it in a
 * ThreadLocal variable. It allows the WebCallbackHandler to populate the
 * HttpServletRequestCallback.
 * 
 * @author Ricardo Arguello (ricardoarguello@users.sourceforge.net)
 * @version $Revision:1$
 */
public class HttpServletRequestValve extends ValveBase
{
   /** ThreadLocal to save the HttpServletRequest. */
   public static ThreadLocal httpRequest = new ThreadLocal();

   /**
    * Default constructor.
    */
   public HttpServletRequestValve()
   {
   }

   /**
    * @see org.apache.catalina.Valve#invoke(org.apache.catalina.connector.Request,
    *      org.apache.catalina.connector.Response)
    */
   public void invoke(Request request, Response response) throws IOException,
         ServletException
   {
      try
      {
         // Set the ThreadLocal
         httpRequest.set(request.getRequest());

         // Perform the request
         getNext().invoke(request, response);
      }
      finally
      {
         // Unset the ThreadLocal
         httpRequest.set(null);
      }
   }
}