/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.web.tomcat.security;

import javax.security.jacc.PolicyContextException;
import javax.security.jacc.PolicyContextHandler;
import javax.servlet.http.HttpServletRequest;

/** A PolicyContextHandler for the active HttpServletRequest
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class HttpServletRequestPolicyContextHandler implements PolicyContextHandler
{
   public static final String WEB_REQUEST_KEY = "javax.servlet.http.HttpServletRequest";
   private static ThreadLocal requestContext = new ThreadLocal();

   static void setRequest(HttpServletRequest bean)
   {
      requestContext.set(bean);
   }

   /** Access the Servlet request policy context data.
    * @param key - "javax.servlet.http.HttpServletRequest"
    * @param data currently unused
    * @return The active HttpServletRequest
    * @throws javax.security.jacc.PolicyContextException
    */ 
   public Object getContext(String key, Object data)
      throws PolicyContextException
   {
      Object context = null;
      if( key.equalsIgnoreCase(WEB_REQUEST_KEY) == true )
         context = requestContext.get();
      return context;
   }

   public String[] getKeys()
      throws PolicyContextException
   {
      String[] keys = {WEB_REQUEST_KEY};
      return keys;
   }

   public boolean supports(String key)
      throws PolicyContextException
   {
      return key.equalsIgnoreCase(WEB_REQUEST_KEY);
   }

}
