/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.xml.multispaced.pm.jdbc;

import org.jboss.xml.binding.ContentNavigator;
import org.jboss.xml.binding.ObjectModelFactory;
import org.xml.sax.Attributes;

/**
 * @author <a href="mailto:alex@jboss.org">Alexey Loubyansky</a>
 * @version <tt>$Revision:1$</tt>
 */
public class JDBCPmMetaDataFactory
   implements ObjectModelFactory
{
   public static final JDBCPmMetaDataFactory INSTANCE = new JDBCPmMetaDataFactory();

   private JDBCPmMetaDataFactory()
   {
   }

   public Object newRoot(Object root,
                         ContentNavigator navigator,
                         String namespaceURI,
                         String localName,
                         Attributes attrs)
   {
      return new JDBCPm();
   }

   public void setValue(JDBCPm pm, ContentNavigator navigator, String namespaceUri, String localName, String value)
   {
      if("datasource".equals(localName))
      {
         pm.setDatasource(value);
      }
      else if("table".equals(localName))
      {
         pm.setTable(value);
      }
   }
}
