/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.xml.multispaced.pm.jdbc;

/**
 * @version <tt>$Revision:1$</tt>
 * @author <a href="mailto:alex@jboss.org">Alexey Loubyansky</a>
 */
public class JDBCPm
{
   private String datasource;
   private String table;

   public String getDatasource()
   {
      return datasource;
   }

   public void setDatasource(String datasource)
   {
      this.datasource = datasource;
   }

   public String getTable()
   {
      return table;
   }

   public void setTable(String table)
   {
      this.table = table;
   }

   public String toString()
   {
      return "[datasource=" + datasource + ", table=" + table + ']';
   }

   public boolean equals(Object o)
   {
      if(this == o) return true;
      if(!(o instanceof JDBCPm)) return false;

      final JDBCPm jdbcPm = (JDBCPm)o;

      if(datasource != null ? !datasource.equals(jdbcPm.datasource) : jdbcPm.datasource != null) return false;
      if(table != null ? !table.equals(jdbcPm.table) : jdbcPm.table != null) return false;

      return true;
   }

   public int hashCode()
   {
      int result;
      result = (datasource != null ? datasource.hashCode() : 0);
      result = 29 * result + (table != null ? table.hashCode() : 0);
      return result;
   }
}
