/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.xml;

import junit.framework.TestCase;
import org.jboss.test.xml.person.Person;
import org.jboss.xml.binding.SchemalessObjectModelFactory;
import org.jboss.xml.binding.Unmarshaller;
import org.jboss.xml.binding.SchemalessMarshaller;
import org.jboss.logging.Logger;

import java.io.StringReader;
import java.io.StringWriter;

/**
 * @author <a href="mailto:alex@jboss.org">Alexey Loubyansky</a>
 * @version <tt>$Revision:1$</tt>
 */
public class SchemalessTestCase
   extends TestCase
{
   private static final Logger log = Logger.getLogger(SchemalessTestCase.class);

   public SchemalessTestCase()
   {
   }

   public SchemalessTestCase(String localName)
   {
      super(localName);
   }

   public void testSchemalessMarshalling() throws Exception
   {
      Person person = Person.newInstance();
      StringWriter writer = new StringWriter();

      SchemalessMarshaller marshaller = new SchemalessMarshaller();
      marshaller.marshal(person, writer);

      log.info("marshalled:\n" + writer.getBuffer());

      StringReader reader = new StringReader(writer.getBuffer().toString());
      Unmarshaller unmarshaller = new Unmarshaller();
      SchemalessObjectModelFactory factory = new SchemalessObjectModelFactory();
      Person unmarshalled = (Person)unmarshaller.unmarshal(reader, factory, null);

      log.info("unmarshalled: " + unmarshalled);
      assertEquals(person, unmarshalled);
   }

}
