/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.wsdlimport;

// $Id:SchemaImportTestCase.java,v 1.0, 2005-06-24 19:15:30Z, Robert Worsnop$

import junit.framework.Test;
import org.jboss.test.JBossTestCase;

import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceFactory;
import java.net.URL;

/**
 * Test schema import in the wsdl.
 *
 * @author Thomas.Diesler@jboss.org
 * @since 07-Feb-2005
 */
public class SchemaImportTestCase extends JBossTestCase
{
   private final String WSDL_LOCATION = "http://" + getServerHost() + ":8080/ws4ee-wsdlimport2/HelloPort?wsdl";
   private String NAMESPACE = "http://org.jboss.webservice/example";
   private final QName SERVICE_NAME = new QName(NAMESPACE, "HelloService");

   /**
    * Construct the test case with a given name
    */
   public SchemaImportTestCase(String name)
   {
      super(name);
   }

   /**
    * deploy the test archives
    */
   public static Test suite() throws Exception
   {
      return getDeploySetup(SchemaImportTestCase.class, "ws4ee-wsdlimport2.war");
   }

   /**
    * Test DII access
    */
   public void testHello() throws Exception
   {
      ServiceFactory serviceFactory = ServiceFactory.newInstance();
      Service service = serviceFactory.createService(new URL(WSDL_LOCATION), SERVICE_NAME);
      Call call = (Call)service.createCall(new QName(NAMESPACE, "HelloServicePort"), "helloString");
      String retstr = (String)call.invoke(new Object[]{"Tom"});
      assertEquals("Hello Tom!", retstr);
   }
}
