/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.wsdlimport;

// $Id:AbsoluteImportTestCase.java,v 1.0, 2005-06-24 18:43:08Z, Robert Worsnop$

import junit.framework.Test;
import org.jboss.test.JBossTestCase;

import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceFactory;
import java.net.URL;

/**
 * Test an absolute import in a wsdl.
 *
 * @author Thomas.Diesler@jboss.org
 * @since 09-Nov-2004
 */
public class AbsoluteImportTestCase extends JBossTestCase
{
   private final String WSDL_LOCATION = "http://" + getServerHost() + ":8080/ws4ee-wsdlimport/HelloPort?wsdl";
   private String NAMESPACE = "http://test.jboss.org/ws4eesimple";
   private final QName SERVICE_NAME = new QName(NAMESPACE, "HelloWsService");

   /**
    * Construct the test case with a given name
    */
   public AbsoluteImportTestCase(String name)
   {
      super(name);
   }

   /**
    * deploy the test archives
    */
   public static Test suite() throws Exception
   {
      return getDeploySetup(AbsoluteImportTestCase.class, "ws4ee-wsdlimport.war");
   }

   /**
    * Test DII access
    */
   public void testHello() throws Exception
   {
      ServiceFactory serviceFactory = ServiceFactory.newInstance();
      Service service = serviceFactory.createService(new URL(WSDL_LOCATION), SERVICE_NAME);
      Call call = (Call)service.createCall(new QName(NAMESPACE, "HelloPortComponent"), "sayHello");
      String retstr = (String)call.invoke(new Object[]{"Hello"});
      assertEquals("'Hello' to you too!", retstr);
   }
}
