/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.samples2docclient;


// $Id:OrderProcessDOCTestCase.java,v 1.0, 2005-06-24 19:13:30Z, Robert Worsnop$

import junit.framework.Test;
import org.jboss.test.webservice.WebserviceTestBase;

import javax.naming.InitialContext;

/**
 * Test access to a complex doc/literal endpoint
 *
 * @author Thomas.Diesler@jboss.org
 * @since 26-Apr-2004
 */
public class OrderProcessDOCTestCase extends WebserviceTestBase
{

   public OrderProcessDOCTestCase(String name)
   {
      super(name);
   }

   /** Deploy the test */
   public static Test suite() throws Exception
   {
      return getDeploySetup(OrderProcessDOCTestCase.class, "ws4ee-samples2-doc.war, ws4ee-samples2-doc-client.jar");
   }

   /** Test a valid access */
   public void testValidAccess() throws Exception
   {
      InitialContext iniCtx = getClientContext();
      OrderProcessService service = (OrderProcessService)iniCtx.lookup("java:comp/env/service/OrderProcess");
      OrderProcess endpoint = service.getOrderProcessPort();

      Person p = new Person(3, "Tom");
      OrderItem i0 = new OrderItem("Ferrari", 1);
      OrderItem i1 = new OrderItem("Twix", 10);
      OrderItem i2 = new OrderItem("IceCream", 3);

      ProcessOrder reqStruct = new ProcessOrder(new OrderItem[]{i0, i1, i2}, p);
      ProcessOrderResponse resStruct = endpoint.processOrder(reqStruct);

      OrderResponse res = resStruct.getResult();
      assertEquals(3, res.getItems().length);

      assertEquals(i0.getName(), res.getItems()[0].getName());
      assertEquals(i0.getQuantity(), res.getItems()[0].getQuantity());

      assertEquals(i1.getName(), res.getItems()[1].getName());
      assertEquals(i1.getQuantity(), res.getItems()[1].getQuantity());

      assertEquals(i2.getName(), res.getItems()[2].getName());
      assertEquals(i2.getQuantity(), res.getItems()[2].getQuantity());

      assertEquals("aproved", res.getMessage());
   }

   /** Test a invalid access */
   public void testNullPerson() throws Exception
   {
      InitialContext iniCtx = getClientContext();
      OrderProcessService service = (OrderProcessService)iniCtx.lookup("java:comp/env/service/OrderProcess");
      OrderProcess endpoint = service.getOrderProcessPort();

      OrderItem i0 = new OrderItem("Ferrari", 1);
      OrderItem i1 = new OrderItem("Twix", 10);
      OrderItem i2 = new OrderItem("IceCream", 3);

      try
      {
         ProcessOrder reqStruct = new ProcessOrder(new OrderItem[]{i0, i1, i2}, null);
         endpoint.processOrder(reqStruct);
         fail("OrderException expected");
      }
      catch (OrderException e)
      {
         // ignore expected exception
      }
   }

   /** Test a invalid access */
   public void testTooManyItems() throws Exception
   {
      InitialContext iniCtx = getClientContext();
      OrderProcessService service = (OrderProcessService)iniCtx.lookup("java:comp/env/service/OrderProcess");
      OrderProcess endpoint = service.getOrderProcessPort();

      Person p = new Person(3, "Tom");
      OrderItem i0 = new OrderItem("Ferrari", 1);
      OrderItem i1 = new OrderItem("Twix", 10);
      OrderItem i2 = new OrderItem("IceCream", 3);
      OrderItem i3 = new OrderItem("GameBoy", 1);

      try
      {
         ProcessOrder reqStruct = new ProcessOrder(new OrderItem[]{i0, i1, i2, i3}, p);
         endpoint.processOrder(reqStruct);
         fail("OrderException expected");
      }
      catch (OrderException e)
      {
         // ignore expected exception
      }
   }
}
