/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.webservice.samples2;

// $Id:OrderProcessImpl.java,v 1.0, 2005-06-24 19:13:30Z, Robert Worsnop$

/**
 * An example of a complex service endpoint impl
 *
 * @author Thomas.Diesler@jboss.org
 * @since 26-Apr-2004
 */
public class OrderProcessImpl implements OrderProcess
{
   public OrderResponse processOrder(OrderItem[] items, Person person) throws OrderException
   {
      if (person == null || person.getName() == null)
         throw new OrderException("Invalid person");

      if (items == null)
         throw new OrderException("Invalid order items");

      if (items.length > 3)
         throw new OrderException("Too many order items");

      OrderResponse res = new OrderResponse(items, "aproved");
      return res;
   }
}
